/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.internal;

import gg.jte.html.HtmlPolicy;
import gg.jte.internal.ClassInfo;
import gg.jte.internal.TemplateLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class RuntimeTemplateLoader
extends TemplateLoader {
    private final ClassLoader singleClassLoader = this.createClassLoader();

    public RuntimeTemplateLoader(Path classDirectory) {
        super(classDirectory);
    }

    @Override
    protected ClassLoader createClassLoader() {
        if (this.classDirectory == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return super.createClassLoader();
    }

    @Override
    protected ClassInfo getClassInfo(ClassLoader classLoader, String className) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            ClassInfo classInfo = new ClassInfo((String)clazz.getField("JTE_NAME").get(null), "");
            classInfo.lineInfo = (int[])clazz.getField("JTE_LINE_INFO").get(null);
            return classInfo;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.singleClassLoader;
    }

    @Override
    public void setNullSafeTemplateCode(boolean value) {
    }

    @Override
    public void setHtmlPolicy(HtmlPolicy htmlPolicy) {
    }

    @Override
    public void setHtmlTags(String[] htmlTags) {
    }

    @Override
    public void setHtmlAttributes(String[] htmlAttributes) {
    }

    @Override
    public List<String> getTemplatesUsing(String name) {
        return Collections.emptyList();
    }

    @Override
    public void cleanAll() {
    }

    @Override
    public int precompileAll(List<String> compilePath) {
        return 0;
    }

    @Override
    public boolean hasChanged(String name) {
        return false;
    }
}

