/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.runtime;

import gg.jte.TemplateException;
import gg.jte.TemplateOutput;
import gg.jte.html.HtmlInterceptor;
import gg.jte.html.HtmlTemplateOutput;
import gg.jte.runtime.TemplateType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Template {
    private final String name;
    private final TemplateType type;
    private final Class<?> clazz;
    private final int parameterCount;
    private Method render;
    private Method renderMap;
    private Map<String, Class<?>> parameterInfo;

    public Template(String name, TemplateType type, Class<?> clazz) {
        this.name = name;
        this.type = type;
        this.clazz = clazz;
        this.findRenderMethods(clazz);
        this.parameterCount = this.resolveParameterCount();
    }

    public void render(TemplateOutput output, HtmlInterceptor htmlInterceptor, Object param) throws Throwable {
        try {
            if (this.parameterCount == 0) {
                this.render.invoke(null, output, htmlInterceptor);
            } else {
                this.render.invoke(null, output, htmlInterceptor, param);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (IllegalArgumentException e) {
            if (this.render.getParameterTypes()[0] == HtmlTemplateOutput.class && !(output instanceof HtmlTemplateOutput)) {
                throw new TemplateException("The template " + this.name + " was compiled with ContentType.Html, but the template engine was initialized with ContentType.Plain. Please initialize the template engine with ContentType.Html.", e);
            }
            String expectedType = this.render.getParameterTypes()[2].getName();
            String actualType = param != null ? param.getClass().getName() : null;
            throw new TemplateException("Failed to render " + this.name + ", type mismatch for parameter: Expected " + expectedType + ", got " + actualType, e);
        }
    }

    public void renderMap(TemplateOutput output, HtmlInterceptor htmlInterceptor, Map<String, Object> params) throws Throwable {
        try {
            this.renderMap.invoke(null, output, htmlInterceptor, params);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public ClassLoader getClassLoader() {
        return this.clazz.getClassLoader();
    }

    private void findRenderMethods(Class<?> clazz) {
        for (Method declaredMethod : clazz.getDeclaredMethods()) {
            if ("render".equals(declaredMethod.getName())) {
                this.render = declaredMethod;
                continue;
            }
            if (!"renderMap".equals(declaredMethod.getName())) continue;
            this.renderMap = declaredMethod;
        }
        if (this.render == null) {
            throw new IllegalStateException("Failed to init " + (Object)((Object)this.type) + " " + this.name + ", no method named 'render' found in " + clazz);
        }
        if (this.renderMap == null) {
            throw new IllegalStateException("Failed to init " + (Object)((Object)this.type) + " " + this.name + ", no method named 'renderMap' found in " + clazz);
        }
    }

    private int resolveParameterCount() {
        if (this.type == TemplateType.Layout) {
            return this.render.getParameterCount() - 3;
        }
        return this.render.getParameterCount() - 2;
    }

    public Map<String, Class<?>> getParamInfo() {
        if (this.parameterInfo == null) {
            this.parameterInfo = this.calculateParameterInfo();
        }
        return this.parameterInfo;
    }

    private Map<String, Class<?>> calculateParameterInfo() {
        HashMap result = new HashMap();
        Parameter[] parameters = this.render.getParameters();
        for (int i = 2; i < parameters.length; ++i) {
            if (!parameters[i].isNamePresent()) {
                throw new TemplateException("No parameter information is available for " + this.name + ", compile templates with -parameters flag, to use this method.");
            }
            result.put(parameters[i].getName(), parameters[i].getType());
        }
        return Collections.unmodifiableMap(result);
    }
}

