/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.support;

import gg.jte.Content;
import gg.jte.TemplateOutput;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface LocalizationSupport {
    public static final Pattern pattern = Pattern.compile("\\{(\\d+)}");

    public String lookup(String var1);

    default public Content localize(String key) {
        String value = this.lookup(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        return output -> output.writeContent(value);
    }

    default public Content localize(String key, final Object ... params) {
        final String value = this.lookup(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        return new Content(){

            @Override
            public void writeTo(TemplateOutput output) {
                Matcher matcher = pattern.matcher(value);
                if (matcher.find()) {
                    int startIndex = 0;
                    do {
                        Object param;
                        output.writeContent(value.substring(startIndex, matcher.start()));
                        startIndex = matcher.end();
                        int argumentIndex = Integer.parseInt(matcher.group(1));
                        if (argumentIndex >= params.length || (param = params[argumentIndex]) == null) continue;
                        this.writeParam(output, param);
                    } while (matcher.find());
                    output.writeContent(value.substring(startIndex));
                } else {
                    output.writeContent(value);
                }
            }

            private void writeParam(TemplateOutput output, Object param) {
                if (param instanceof String) {
                    output.writeUserContent((String)param);
                } else if (param instanceof Content) {
                    output.writeUserContent((Content)param);
                } else if (param instanceof Enum) {
                    output.writeUserContent((Enum)param);
                } else if (param instanceof Boolean) {
                    output.writeUserContent((boolean)((Boolean)param));
                } else if (param instanceof Byte) {
                    output.writeUserContent((Byte)param);
                } else if (param instanceof Short) {
                    output.writeUserContent((Short)param);
                } else if (param instanceof Integer) {
                    output.writeUserContent((Integer)param);
                } else if (param instanceof Long) {
                    output.writeUserContent((Long)param);
                } else if (param instanceof Float) {
                    output.writeUserContent(((Float)param).floatValue());
                } else if (param instanceof Double) {
                    output.writeUserContent((Double)param);
                } else if (param instanceof Character) {
                    output.writeUserContent(((Character)param).charValue());
                }
            }
        };
    }
}

