/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.html;

import gg.jte.Content;
import gg.jte.TemplateOutput;
import gg.jte.html.HtmlTemplateOutput;
import gg.jte.internal.StringUtils;
import gg.jte.output.StringOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.owasp.encoder.Encode;

public class OwaspHtmlTemplateOutput
implements HtmlTemplateOutput {
    private final TemplateOutput templateOutput;
    private String tagName;
    private String attributeName;

    public OwaspHtmlTemplateOutput(TemplateOutput templateOutput) {
        this.templateOutput = templateOutput;
    }

    @Override
    public void setContext(String tagName, String attributeName) {
        this.tagName = tagName;
        this.attributeName = attributeName;
    }

    @Override
    public void writeUserContent(String value) {
        if (value != null) {
            if (this.tagName != null && this.attributeName != null) {
                this.writeTagAttributeUserContent(value);
            } else if (this.tagName != null) {
                this.writeTagBodyUserContent(value);
            } else {
                this.writeContent(value);
            }
        }
    }

    @Override
    public void writeUserContent(Content content) {
        if (content != null) {
            if (this.tagName != null && this.attributeName != null) {
                StringOutput output = new StringOutput(1024);
                content.writeTo(new OwaspHtmlTemplateOutput(output));
                this.writeTagAttributeUserContent(output.toString());
            } else {
                content.writeTo(this);
            }
        }
    }

    private void writeTagBodyUserContent(String value) {
        try {
            if ("script".equals(this.tagName)) {
                Encode.forJavaScriptBlock((Writer)this.getWriter(), (String)value);
            } else {
                Encode.forHtml((Writer)this.getWriter(), (String)value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeTagAttributeUserContent(String value) {
        if ("a".equals(this.tagName) && "href".equals(this.attributeName) && StringUtils.startsWithIgnoringCaseAndWhitespaces(value, "javascript:")) {
            return;
        }
        try {
            if (this.attributeName.startsWith("on")) {
                Encode.forJavaScriptAttribute((Writer)this.getWriter(), (String)value);
            } else {
                Encode.forHtmlAttribute((Writer)this.getWriter(), (String)value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Writer getWriter() {
        return this.templateOutput.getWriter();
    }

    @Override
    public void writeContent(String value) {
        this.templateOutput.writeContent(value);
    }

    @Override
    public void writeUserContent(boolean value) {
        this.templateOutput.writeUserContent(value);
    }

    @Override
    public void writeUserContent(byte value) {
        this.templateOutput.writeUserContent(value);
    }

    @Override
    public void writeUserContent(short value) {
        this.templateOutput.writeUserContent(value);
    }

    @Override
    public void writeUserContent(int value) {
        this.templateOutput.writeUserContent(value);
    }

    @Override
    public void writeUserContent(long value) {
        this.templateOutput.writeUserContent(value);
    }

    @Override
    public void writeUserContent(float value) {
        this.templateOutput.writeUserContent(value);
    }

    @Override
    public void writeUserContent(double value) {
        this.templateOutput.writeUserContent(value);
    }
}

