/*
 * Decompiled with CFR 0.152.
 */
package gg.jte;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateConfig;
import gg.jte.TemplateException;
import gg.jte.TemplateNotFoundException;
import gg.jte.TemplateOutput;
import gg.jte.html.HtmlInterceptor;
import gg.jte.html.HtmlPolicy;
import gg.jte.html.HtmlTemplateOutput;
import gg.jte.html.OwaspHtmlTemplateOutput;
import gg.jte.runtime.DebugInfo;
import gg.jte.runtime.RuntimeTemplateLoader;
import gg.jte.runtime.Template;
import gg.jte.runtime.TemplateLoader;
import gg.jte.runtime.TemplateMode;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TemplateEngine {
    private final TemplateLoader templateLoader;
    private final TemplateMode templateMode;
    private final ConcurrentHashMap<String, Template> templateCache;
    private final TemplateConfig config;
    private final ContentType contentType;
    private final Path classDirectory;
    private final ClassLoader parentClassLoader;
    private HtmlInterceptor htmlInterceptor;

    public static TemplateEngine create(CodeResolver codeResolver, ContentType contentType) {
        return TemplateEngine.create(codeResolver, Paths.get("jte-classes", new String[0]), contentType);
    }

    public static TemplateEngine create(CodeResolver codeResolver, Path classDirectory, ContentType contentType) {
        return TemplateEngine.create(codeResolver, classDirectory, contentType, null);
    }

    public static TemplateEngine create(CodeResolver codeResolver, Path classDirectory, ContentType contentType, ClassLoader parentClassLoader) {
        return TemplateEngine.create(codeResolver, classDirectory, contentType, parentClassLoader, "gg.jte.generated.ondemand");
    }

    public static TemplateEngine create(CodeResolver codeResolver, Path classDirectory, ContentType contentType, ClassLoader parentClassLoader, String packageName) {
        return new TemplateEngine(codeResolver, classDirectory, contentType, TemplateMode.OnDemand, parentClassLoader, packageName);
    }

    public static TemplateEngine createPrecompiled(Path classDirectory, ContentType contentType) {
        return TemplateEngine.createPrecompiled(classDirectory, contentType, null);
    }

    public static TemplateEngine createPrecompiled(ContentType contentType) {
        return TemplateEngine.createPrecompiled(null, contentType);
    }

    public static TemplateEngine createPrecompiled(Path classDirectory, ContentType contentType, ClassLoader parentClassLoader) {
        return TemplateEngine.createPrecompiled(classDirectory, contentType, parentClassLoader, "gg.jte.generated.precompiled");
    }

    public static TemplateEngine createPrecompiled(Path classDirectory, ContentType contentType, ClassLoader parentClassLoader, String packageName) {
        return new TemplateEngine(null, classDirectory, contentType, TemplateMode.Precompiled, parentClassLoader, packageName);
    }

    private TemplateEngine(CodeResolver codeResolver, Path classDirectory, ContentType contentType, TemplateMode templateMode, ClassLoader parentClassLoader, String packageName) {
        if (contentType == null) {
            throw new NullPointerException("Content type must be specified.");
        }
        this.config = new TemplateConfig(contentType, packageName);
        this.templateLoader = TemplateEngine.createTemplateLoader(this.config, codeResolver, classDirectory, templateMode, parentClassLoader);
        this.templateMode = templateMode;
        this.templateCache = new ConcurrentHashMap();
        this.contentType = contentType;
        this.classDirectory = classDirectory;
        this.parentClassLoader = parentClassLoader;
        if (templateMode == TemplateMode.OnDemand) {
            this.cleanAll();
        }
    }

    private static TemplateLoader createTemplateLoader(TemplateConfig config, CodeResolver codeResolver, Path classDirectory, TemplateMode templateMode, ClassLoader parentClassLoader) {
        if (templateMode == TemplateMode.Precompiled) {
            return new RuntimeTemplateLoader(classDirectory, parentClassLoader, config.packageName);
        }
        try {
            Class<?> compilerClass = Class.forName("gg.jte.compiler.TemplateCompiler");
            return (TemplateLoader)compilerClass.getConstructor(TemplateConfig.class, CodeResolver.class, Path.class, ClassLoader.class).newInstance(config, codeResolver, classDirectory, parentClassLoader);
        }
        catch (Exception e) {
            throw new TemplateException("TemplateCompiler could not be located. Maybe jte isn't on your classpath?", e);
        }
    }

    public void render(String name, Object param, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.render(this.checkOutput(output), this.htmlInterceptor, param);
        }
        catch (Throwable e) {
            throw this.handleRenderException(name, template, e);
        }
    }

    public void render(String name, Map<String, Object> params, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.renderMap(this.checkOutput(output), this.htmlInterceptor, params);
        }
        catch (Throwable e) {
            throw this.handleRenderException(name, template, e);
        }
    }

    private TemplateOutput checkOutput(TemplateOutput templateOutput) {
        if (this.contentType == ContentType.Html && !(templateOutput instanceof HtmlTemplateOutput)) {
            return new OwaspHtmlTemplateOutput(templateOutput);
        }
        return templateOutput;
    }

    private TemplateException handleRenderException(String name, Template template, Throwable e) {
        if (e instanceof TemplateException) {
            return (TemplateException)e;
        }
        ClassLoader classLoader = template.getClassLoader();
        StackTraceElement[] stackTrace = e.getStackTrace();
        DebugInfo debugInfo = this.templateLoader.resolveDebugInfo(classLoader, stackTrace);
        String message = "Failed to render " + name;
        if (debugInfo != null) {
            message = message + ", error at " + debugInfo.name + ":" + debugInfo.line;
            this.templateLoader.rewriteStackTrace(e, classLoader, stackTrace);
        }
        return new TemplateException(message, e);
    }

    public boolean hasTemplate(String name) {
        try {
            this.resolveTemplate(name);
            return true;
        }
        catch (TemplateNotFoundException e) {
            return false;
        }
    }

    public List<String> getTemplatesUsing(String name) {
        return this.templateLoader.getTemplatesUsing(name);
    }

    public Map<String, Class<?>> getParamInfo(String name) throws TemplateException {
        return this.resolveTemplate(name).getParamInfo();
    }

    public void prepareForRendering(String name) {
        this.resolveTemplate(name);
    }

    public void cleanAll() {
        this.templateLoader.cleanAll();
    }

    public List<String> generateAll() {
        return this.templateLoader.generateAll();
    }

    public List<String> precompileAll() {
        return this.templateLoader.precompileAll();
    }

    public List<String> precompileAll(List<String> classPath) {
        this.setClassPath(classPath);
        return this.templateLoader.precompileAll();
    }

    public void clearCache() {
        this.templateCache.clear();
    }

    private Template resolveTemplate(String name) {
        if (this.templateMode == TemplateMode.OnDemand) {
            return this.resolveTemplateOnDemand(name);
        }
        return this.templateCache.computeIfAbsent(name, this.templateLoader::load);
    }

    private Template resolveTemplateOnDemand(String name) {
        RuntimeException[] exception = new RuntimeException[]{null};
        Template result = this.templateCache.compute(name, (templateName, template) -> {
            if (template != null && !this.templateLoader.hasChanged((String)templateName)) {
                return template;
            }
            try {
                if (template == null) {
                    return this.templateLoader.load((String)templateName);
                }
                return this.templateLoader.hotReload((String)templateName);
            }
            catch (RuntimeException e) {
                exception[0] = e;
                return null;
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        return result;
    }

    public TemplateEngine reloadPrecompiled(TemplateEngine precompiler) throws TemplateException {
        precompiler.precompileAll();
        return this.reloadPrecompiled(precompiler.classDirectory);
    }

    public TemplateEngine reloadPrecompiled(Path classDirectory) throws TemplateException {
        TemplateEngine engine = TemplateEngine.createPrecompiled(classDirectory, this.contentType, this.parentClassLoader, this.config.packageName);
        engine.setHtmlInterceptor(this.htmlInterceptor);
        HashSet templates = new HashSet(this.templateCache.keySet());
        for (String templateName : templates) {
            engine.prepareForRendering(templateName);
        }
        return engine;
    }

    public void setCompileArgs(String ... compileArgs) {
        this.config.compileArgs = compileArgs;
    }

    public void setKotlinCompileArgs(String ... compileArgs) {
        this.config.kotlinCompileArgs = compileArgs;
    }

    public void setTrimControlStructures(boolean value) {
        this.config.trimControlStructures = value;
    }

    public void setHtmlPolicy(HtmlPolicy htmlPolicy) {
        if (htmlPolicy == null) {
            throw new NullPointerException("htmlPolicy must not be null");
        }
        this.config.htmlPolicy = htmlPolicy;
    }

    public void setHtmlTags(String ... htmlTags) {
        this.config.htmlTags = htmlTags;
    }

    public void setHtmlInterceptor(HtmlInterceptor htmlInterceptor) {
        this.htmlInterceptor = htmlInterceptor;
    }

    public void setHtmlCommentsPreserved(boolean htmlCommentsPreserved) {
        this.config.htmlCommentsPreserved = htmlCommentsPreserved;
    }

    public void setBinaryStaticContent(boolean binaryStaticContent) {
        this.config.binaryStaticContent = binaryStaticContent;
    }

    public void setClassPath(List<String> classPath) {
        this.config.classPath = classPath;
    }

    public void setTargetResourceDirectory(Path targetResourceDirectory) {
        this.config.resourceDirectory = targetResourceDirectory;
    }

    public void setProjectNamespace(String projectNamespace) {
        this.config.projectNamespace = projectNamespace;
    }

    public void setExtensions(Map<String, Map<String, String>> extensionSettings) {
        this.config.extensionClasses.putAll(extensionSettings);
    }
}

