/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.springframework.boot.autoconfigure;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;

@ConfigurationProperties(prefix="gg.jte")
public class JteProperties {
    private String productionProfileName = "prod";
    private String templateLocation = "src/main/jte";
    private String templateSuffix = ".jte";

    public String getTemplateSuffix() {
        return this.templateSuffix;
    }

    public void setTemplateSuffix(String templateSuffix) {
        this.templateSuffix = templateSuffix;
    }

    public String getProductionProfileName() {
        return this.productionProfileName;
    }

    public void setProductionProfileName(String productionProfileName) {
        this.productionProfileName = productionProfileName;
    }

    public String getTemplateLocation() {
        return this.templateLocation;
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    public boolean isProductionEnabled(@NonNull Environment environment) {
        return Arrays.stream(environment.getActiveProfiles()).anyMatch(it -> it.equals(this.getProductionProfileName()));
    }
}

