/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.springframework.boot.autoconfigure;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.resolve.DirectoryCodeResolver;
import gg.jte.springframework.boot.autoconfigure.JteProperties;
import gg.jte.springframework.boot.autoconfigure.ReactiveJteViewResolver;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.web.reactive.result.view.UrlBasedViewResolver;

@AutoConfiguration
@ConditionalOnClass(value={TemplateEngine.class, UrlBasedViewResolver.class})
@EnableConfigurationProperties(value={JteProperties.class})
public class ReactiveJteAutoConfiguration {
    @Autowired
    private Environment environment;
    @Autowired
    private JteProperties jteProperties;

    @Bean
    @ConditionalOnMissingBean(value={ReactiveJteViewResolver.class})
    public ReactiveJteViewResolver reactiveJteViewResolver(TemplateEngine templateEngine) {
        return new ReactiveJteViewResolver(templateEngine);
    }

    @Bean
    @ConditionalOnMissingBean(value={TemplateEngine.class})
    public TemplateEngine jteTemplateEngine() {
        if (this.jteProperties.isProductionEnabled(this.environment)) {
            return TemplateEngine.createPrecompiled((ContentType)ContentType.Html);
        }
        String[] split = this.jteProperties.getTemplateLocation().split("/");
        DirectoryCodeResolver codeResolver = new DirectoryCodeResolver(FileSystems.getDefault().getPath("", split));
        TemplateEngine templateEngine = TemplateEngine.create((CodeResolver)codeResolver, (Path)Paths.get("jte-classes", new String[0]), (ContentType)ContentType.Html, (ClassLoader)this.getClass().getClassLoader());
        templateEngine.setBinaryStaticContent(true);
        return templateEngine;
    }
}

