/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.springframework.boot.autoconfigure;

import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.Utf8ByteOutput;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReactiveJteView
extends AbstractUrlBasedView {
    private final TemplateEngine templateEngine;

    public ReactiveJteView(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public boolean checkResourceExists(Locale locale) {
        return this.templateEngine.hasTemplate(this.getUrl());
    }

    @NonNull
    protected Mono<Void> renderInternal(@NonNull Map<String, Object> renderAttributes, MediaType contentType, ServerWebExchange exchange) {
        return exchange.getResponse().writeWith((Publisher)Mono.fromCallable(() -> {
            String url = this.getUrl();
            Utf8ByteOutput output = new Utf8ByteOutput();
            this.templateEngine.render(url, renderAttributes, (TemplateOutput)output);
            DataBuffer dataBuffer = exchange.getResponse().bufferFactory().allocateBuffer();
            try {
                output.writeTo(dataBuffer.asOutputStream());
                return dataBuffer;
            }
            catch (IOException ex) {
                DataBufferUtils.release((DataBuffer)dataBuffer);
                String message = "Could not load JTE template for URL [" + this.getUrl() + "]";
                throw new IllegalStateException(message, ex);
            }
            catch (Throwable ex) {
                DataBufferUtils.release((DataBuffer)dataBuffer);
                throw ex;
            }
        }).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release));
    }
}

