/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.springframework.boot.autoconfigure;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.resolve.DirectoryCodeResolver;
import gg.jte.springframework.boot.autoconfigure.JteConfigurationException;
import gg.jte.springframework.boot.autoconfigure.JteProperties;
import gg.jte.springframework.boot.autoconfigure.JteViewResolver;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

@AutoConfiguration
@ConditionalOnClass(value={TemplateEngine.class, AbstractTemplateViewResolver.class})
@EnableConfigurationProperties(value={JteProperties.class})
public class JteAutoConfiguration {
    private final JteProperties jteProperties;

    public JteAutoConfiguration(JteProperties jteProperties) {
        this.jteProperties = jteProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={JteViewResolver.class})
    public JteViewResolver jteViewResolver(TemplateEngine templateEngine) {
        return new JteViewResolver(templateEngine, this.jteProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={TemplateEngine.class})
    public TemplateEngine jteTemplateEngine() {
        if (this.jteProperties.isDevelopmentMode() && this.jteProperties.usePreCompiledTemplates()) {
            throw new JteConfigurationException("You can't use development mode and precompiledTemplates together");
        }
        if (this.jteProperties.usePreCompiledTemplates()) {
            return TemplateEngine.createPrecompiled((ContentType)ContentType.Html);
        }
        if (this.jteProperties.isDevelopmentMode()) {
            String[] split = this.jteProperties.getTemplateLocation().split("/");
            DirectoryCodeResolver codeResolver = new DirectoryCodeResolver(FileSystems.getDefault().getPath("", split));
            return TemplateEngine.create((CodeResolver)codeResolver, (Path)Paths.get("jte-classes", new String[0]), (ContentType)ContentType.Html, (ClassLoader)this.getClass().getClassLoader());
        }
        throw new JteConfigurationException("You need to either set gg.jte.usePrecompiledTemplates or gg.jte.developmentMode to true ");
    }
}

