/*
 * Decompiled with CFR 0.152.
 */
package gg.nils.semanticrelease.maven.plugin;

import gg.nils.semanticrelease.config.DefaultSemanticReleaseConfig;
import gg.nils.semanticrelease.config.SemanticReleaseConfig;
import gg.nils.semanticrelease.maven.plugin.SemanticReleaseModelProcessor;
import gg.nils.semanticrelease.maven.plugin.session.SessionHolder;
import gg.nils.semanticrelease.maven.plugin.session.impl.SessionImpl;
import gg.nils.semanticrelease.maven.plugin.util.MavenPluginProperties;
import gg.nils.semanticrelease.maven.plugin.util.Utils;
import gg.nils.semanticrelease.versioncontrol.VersionControlProvider;
import gg.nils.semanticrelease.versioncontrol.git.GitVersionControlProvider;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.building.ModelProcessor;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="semantic-release")
public class SemanticReleaseExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private ModelProcessor modelProcessor;
    @Requirement
    private SessionHolder sessionHolder;

    public void afterSessionStart(MavenSession mavenSession) throws MavenExecutionException {
        if (Utils.shouldSkip(mavenSession)) {
            this.logger.info("  semantic-release execution has been skipped by request of the user");
            this.sessionHolder.setSession(null);
            return;
        }
        File rootDirectory = mavenSession.getRequest().getMultiModuleProjectDirectory();
        this.logger.debug("using semantic-release on directory: " + rootDirectory);
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(rootDirectory);
        if (repositoryBuilder == null || repositoryBuilder.getGitDir() == null) {
            this.logger.warn("Not a git repository");
            return;
        }
        try (Repository repository = repositoryBuilder.build();){
            this.logger.info(String.format("Using semantic-release-maven-plugin [%s] (sha1: %s)", MavenPluginProperties.getVersion(), MavenPluginProperties.getSHA1()));
            long start = System.currentTimeMillis();
            Git git = new Git(repository);
            DefaultSemanticReleaseConfig config = new DefaultSemanticReleaseConfig();
            GitVersionControlProvider versionControlProvider = new GitVersionControlProvider((SemanticReleaseConfig)config, git);
            String computedVersion = versionControlProvider.getFullVersionWithoutDirty();
            long duration = System.currentTimeMillis() - start;
            this.logger.info(String.format("    version '%s' computed in %d ms", computedVersion, duration));
            this.logger.info("");
            Utils.fillPropertiesFromMetadatas(mavenSession.getUserProperties(), (VersionControlProvider)versionControlProvider, this.logger);
            SessionImpl session = new SessionImpl(computedVersion, rootDirectory);
            this.sessionHolder.setSession(session);
        }
        catch (IOException e) {
            this.logger.warn("Could not generate version for project: " + rootDirectory, (Throwable)e);
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        this.sessionHolder.setSession(null);
    }

    public void afterProjectsRead(MavenSession mavenSession) throws MavenExecutionException {
        File projectBaseDir;
        if (!Utils.shouldSkip(mavenSession) && (projectBaseDir = mavenSession.getCurrentProject().getBasedir()) != null) {
            Consumer<CharSequence> c = cs -> this.logger.warn(cs.toString());
            if (SemanticReleaseModelProcessor.class.isAssignableFrom(this.modelProcessor.getClass())) {
                if (!mavenSession.getUserProperties().containsKey("semantic-release.session")) {
                    Utils.failAsOldMechanism(c);
                }
            } else {
                Utils.failAsOldMechanism(c);
            }
            this.sessionHolder.session().ifPresent(session -> {
                this.logger.info("semantic-release-maven-plugin is about to change project(s) version(s)");
                session.getProjects().forEach(gav -> this.logger.info("    " + gav.toString() + " -> " + session.getVersion()));
            });
        }
    }
}

