/*
 * Decompiled with CFR 0.152.
 */
package gg.nils.semanticrelease.maven.plugin.util;

import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;

public class GAV {
    private String groupId;
    private String artifactId;
    private String version;

    public GAV() {
    }

    public GAV(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public static GAV from(MavenProject project) {
        return new GAV(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static GAV from(Model model) {
        String groupId;
        String string = model.getGroupId() != null ? model.getGroupId() : (groupId = model.getParent() != null ? model.getParent().getGroupId() : null);
        String version = model.getVersion() != null ? model.getVersion() : (model.getParent() != null ? model.getParent().getVersion() : null);
        return new GAV(groupId, model.getArtifactId(), version);
    }

    public static GAV from(Parent parent) {
        return new GAV(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GAV gav = (GAV)o;
        return Objects.equals(this.groupId, gav.groupId) && Objects.equals(this.artifactId, gav.artifactId) && Objects.equals(this.version, gav.version);
    }

    public String toString() {
        return String.format("%s::%s::%s", this.groupId, this.artifactId, this.version);
    }
}

