/*
 * Decompiled with CFR 0.152.
 */
package gg.nils.semanticrelease.maven.plugin.util;

import gg.nils.semanticrelease.RawCommit;
import gg.nils.semanticrelease.maven.plugin.util.GAV;
import gg.nils.semanticrelease.maven.plugin.util.MavenPluginProperties;
import gg.nils.semanticrelease.versioncontrol.VersionControlProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class Utils {
    public static final String EXTENSION_PREFIX = "semantic-release";
    public static final String EXTENSION_GROUP_ID = "gg.nils";
    public static final String EXTENSION_ARTIFACT_ID = "semantic-release-maven-plugin";
    public static final String EXTENSION_SKIP = "semantic-release.skip";
    public static final String EXTENSION_FORCE_COMPUTATION = "semantic-release.forceComputation";
    public static final String EXTENSION_FLATTEN = "semantic-release.flatten";
    public static final String EXTENSION_USE_VERSION = "semantic-release.use-version";
    public static final String SESSION_MAVEN_PROPERTIES_KEY = "semantic-release.session";
    public static final String PROJECT_VERSION = "${project.version}";

    private Utils() {
    }

    public static Model loadInitialModel(File pomFile) throws IOException, XmlPullParserException {
        try (FileReader fileReader = new FileReader(pomFile);){
            Model model = new MavenXpp3Reader().read((Reader)fileReader);
            return model;
        }
    }

    public static File createPomDumpFile() throws IOException {
        File tmp = File.createTempFile("pom", ".semantic-release-maven-plugin.xml");
        tmp.deleteOnExit();
        return tmp;
    }

    public static void writeModelPom(Model mavenModel, File pomFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter(pomFile);){
            new MavenXpp3Writer().write((Writer)fileWriter, mavenModel);
        }
    }

    public static void changeBaseDir(MavenProject project, File initialBaseDir) throws NoSuchFieldException, IllegalAccessException {
        Field basedirField = project.getClass().getField("basedir");
        basedirField.setAccessible(true);
        basedirField.set(project, initialBaseDir);
    }

    public static void setProjectPomFile(MavenProject project, File newPom, Logger logger) {
        try {
            project.setPomFile(newPom);
        }
        catch (Throwable unused) {
            logger.warn("maven version might be <= 3.2.4, changing pom file using old mechanism");
            File initialBaseDir = project.getBasedir();
            project.setFile(newPom);
            File newBaseDir = project.getBasedir();
            try {
                if (!initialBaseDir.getCanonicalPath().equals(newBaseDir.getCanonicalPath())) {
                    Utils.changeBaseDir(project, initialBaseDir);
                }
            }
            catch (Exception ex) {
                GAV gav = GAV.from(project);
                logger.warn("cannot reset basedir of project " + gav.toString(), (Throwable)ex);
            }
        }
    }

    public static void fillPropertiesFromMetadatas(Properties properties, VersionControlProvider provider, Logger logger) {
        String calculatedVersion = provider.getFullVersionWithoutDirty();
        logger.debug("semantic-release calculated version number: " + calculatedVersion);
        properties.put("semantic-release.used_version", calculatedVersion);
        properties.put("semantic-release.calculated_version", calculatedVersion);
        properties.put("semantic-release.dirty", Boolean.toString(provider.hasUncommittedChanges()));
        List rawCommits = provider.getRawCommits();
        String commitId = rawCommits.isEmpty() ? "0000000000000000000000000000000000000000" : ((RawCommit)rawCommits.get(0)).getCommitId();
        properties.put("semantic-release.git_sha1_full", commitId);
        properties.put("semantic-release.branch_name", provider.getCurrentBranch().getName());
        properties.put("semantic-release.plugin-version", MavenPluginProperties.getVersion());
    }

    public static void attachModifiedPomFilesToTheProject(List<MavenProject> projects, Set<GAV> gavs, String version, Boolean resolveProjectVersion, Logger logger) throws IOException, XmlPullParserException {
        for (MavenProject project : projects) {
            GAV parentGAV;
            Model model = Utils.loadInitialModel(project.getFile());
            GAV initalProjectGAV = GAV.from(model);
            logger.debug("about to change file pom for: " + initalProjectGAV);
            if (gavs.contains(initalProjectGAV)) {
                model.setVersion(version);
                if (model.getScm() != null && project.getModel().getScm() != null) {
                    model.getScm().setTag(project.getModel().getScm().getTag());
                }
            }
            if (model.getParent() != null && gavs.contains(parentGAV = GAV.from(model.getParent()))) {
                model.getParent().setVersion(version);
            }
            if (resolveProjectVersion.booleanValue()) {
                Utils.resolveProjectVersionVariable(version, model);
            }
            File newPom = Utils.createPomDumpFile();
            Utils.writeModelPom(model, newPom);
            logger.debug("    new pom file created for " + initalProjectGAV + " under " + newPom);
            Utils.setProjectPomFile(project, newPom, logger);
            logger.debug("    pom file set");
        }
    }

    private static void resolveProjectVersionVariable(String version, Model model) {
        if (model.getProperties() != null) {
            for (Map.Entry<Object, Object> entry : model.getProperties().entrySet()) {
                if (!PROJECT_VERSION.equals(entry.getValue())) continue;
                entry.setValue(version);
            }
        }
        if (model.getDependencies() != null) {
            for (Dependency dependency : model.getDependencies()) {
                if (!PROJECT_VERSION.equals(dependency.getVersion())) continue;
                dependency.setVersion(version);
            }
        }
        if (model.getDependencyManagement() != null && model.getDependencyManagement().getDependencies() != null) {
            for (Dependency dependency : model.getDependencyManagement().getDependencies()) {
                if (!PROJECT_VERSION.equals(dependency.getVersion())) continue;
                dependency.setVersion(version);
            }
        }
        if (model.getBuild() != null && model.getBuild().getPlugins() != null) {
            for (Plugin plugin : model.getBuild().getPlugins()) {
                if (plugin.getDependencies() == null) continue;
                for (Dependency dependency : plugin.getDependencies()) {
                    if (!PROJECT_VERSION.equals(dependency.getVersion())) continue;
                    dependency.setVersion(version);
                }
            }
        }
        if (model.getBuild() != null && model.getBuild().getPluginManagement() != null && model.getBuild().getPluginManagement().getPlugins() != null) {
            for (Plugin plugin : model.getBuild().getPluginManagement().getPlugins()) {
                if (plugin.getDependencies() == null) continue;
                for (Dependency dependency : plugin.getDependencies()) {
                    if (!PROJECT_VERSION.equals(dependency.getVersion())) continue;
                    dependency.setVersion(version);
                }
            }
        }
    }

    public static void failAsOldMechanism(Consumer<? super CharSequence> logger) throws MavenExecutionException {
        logger.accept("semantic-release has changed!");
        logger.accept("");
        logger.accept("it now requires the usage of maven core extensions (> 3.3.1) instead of standard plugin extensions.");
        logger.accept("The plugin must be now declared in a `.mvn/extensions.xml` file.");
        logger.accept("");
        logger.accept("    read https://github.com/semantic-release/semantic-release-maven-plugin for further information");
        logger.accept("");
        throw new MavenExecutionException("detection of semantic-release old setting mechanism", (Throwable)new IllegalStateException("semantic-release must now use maven core extensions only"));
    }

    public static boolean shouldSkip(MavenSession session) {
        return Boolean.parseBoolean(session.getSystemProperties().getProperty(EXTENSION_SKIP, "false")) || Boolean.parseBoolean(session.getUserProperties().getProperty(EXTENSION_SKIP, "false"));
    }

    public static boolean shouldUseFlattenPlugin(MavenSession session) {
        return Boolean.parseBoolean(session.getSystemProperties().getProperty(EXTENSION_FLATTEN, "false")) || Boolean.parseBoolean(session.getUserProperties().getProperty(EXTENSION_FLATTEN, "false"));
    }

    public static Optional<String> versionOverride(MavenSession session, Logger logger) {
        return Utils.getProperty(session, EXTENSION_USE_VERSION, logger);
    }

    public static Optional<String> getProperty(MavenSession session, String propertyName, Logger logger) {
        String normalizedSystemPropertyName = Utils.normalizeSystemPropertyName(propertyName);
        String value = session.getUserProperties().getProperty(propertyName);
        if (value != null) {
            logger.debug(String.format("Found '%s'='%s' in user properties", propertyName, value));
            return Optional.of(value);
        }
        value = session.getUserProperties().getProperty(normalizedSystemPropertyName);
        if (value != null) {
            logger.debug(String.format("Found '%s'='%s' in user properties", normalizedSystemPropertyName, value));
            return Optional.of(value);
        }
        String envPrefix = "env.";
        value = session.getSystemProperties().getProperty("env." + propertyName);
        if (value != null) {
            logger.debug(String.format("Found '%s'='%s' in system properties (as env property)", propertyName, value));
            return Optional.of(value);
        }
        value = session.getSystemProperties().getProperty("env." + normalizedSystemPropertyName);
        if (value != null) {
            logger.debug(String.format("Found '%s'='%s' in system properties (as env property)", normalizedSystemPropertyName, value));
            return Optional.of(value);
        }
        value = session.getSystemProperties().getProperty(propertyName);
        if (value != null) {
            logger.debug(String.format("Found '%s'='%s' in system properties (as system property)", propertyName, value));
            return Optional.of(value);
        }
        value = session.getSystemProperties().getProperty(normalizedSystemPropertyName);
        if (value != null) {
            logger.debug(String.format("Found '%s'='%s' in system properties (as system property)", normalizedSystemPropertyName, value));
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static String normalizeSystemPropertyName(String mavenPropertyName) {
        if (StringUtils.isBlank((CharSequence)mavenPropertyName)) {
            throw new IllegalStateException("It's not possible to normalize a blank name into a compliant name");
        }
        return StringUtils.replacePattern((String)StringUtils.replacePattern((String)mavenPropertyName, (String)"[^a-zA-Z0-9_]", (String)"_"), (String)"^[0-9]", (String)"_");
    }

    public static interface CLI {
        public static final String OVERRIDE_CONFIG_FILE = "semantic-release.config";
    }
}

