/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

import global.namespace.fun.io.api.ArchiveInputStream;
import global.namespace.fun.io.api.ArchiveOutputStream;
import global.namespace.fun.io.api.ArchiveSink;
import global.namespace.fun.io.api.ArchiveSource;
import global.namespace.fun.io.api.ArchiveStore;
import global.namespace.fun.io.api.Codec;
import global.namespace.fun.io.api.Filter;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.api.Store;
import global.namespace.fun.io.api.function.XFunction;
import global.namespace.fun.io.api.function.XSupplier;
import global.namespace.fun.io.bios.Base64Filter;
import global.namespace.fun.io.bios.BufferFilter;
import global.namespace.fun.io.bios.CipherFilter;
import global.namespace.fun.io.bios.DeflateFilter;
import global.namespace.fun.io.bios.DirectoryStore;
import global.namespace.fun.io.bios.GZIPFilter;
import global.namespace.fun.io.bios.InflateFilter;
import global.namespace.fun.io.bios.JarOutputStreamAdapter;
import global.namespace.fun.io.bios.MemoryStore;
import global.namespace.fun.io.bios.PreferencesStore;
import global.namespace.fun.io.bios.RealPathStore;
import global.namespace.fun.io.bios.SerializationCodec;
import global.namespace.fun.io.bios.XMLCodec;
import global.namespace.fun.io.bios.ZipFileAdapter;
import global.namespace.fun.io.bios.ZipOutputStreamAdapter;
import global.namespace.fun.io.spi.Copy;
import global.namespace.fun.io.spi.UncloseableInputStream;
import global.namespace.fun.io.spi.UncloseableOutputStream;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarOutputStream;
import java.util.prefs.Preferences;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;

public final class BIOS {
    private BIOS() {
    }

    public static Codec serialization() {
        return new SerializationCodec();
    }

    public static Codec xml() {
        return BIOS.xml((XFunction<? super OutputStream, ? extends XMLEncoder>)((XFunction)XMLEncoder::new), (XFunction<? super InputStream, ? extends XMLDecoder>)((XFunction)XMLDecoder::new));
    }

    public static Codec xml(XFunction<? super OutputStream, ? extends XMLEncoder> xmlEncoders, XFunction<? super InputStream, ? extends XMLDecoder> xmlDecoders) {
        return new XMLCodec(Objects.requireNonNull(xmlEncoders), Objects.requireNonNull(xmlDecoders));
    }

    public static Filter base64() {
        return BIOS.base64(Base64.getEncoder(), Base64.getDecoder());
    }

    public static Filter base64(Base64.Encoder e, Base64.Decoder d) {
        return new Base64Filter(Objects.requireNonNull(e), Objects.requireNonNull(d));
    }

    public static Filter buffer() {
        return BIOS.buffer(8192);
    }

    public static Filter buffer(int size) {
        return new BufferFilter(size);
    }

    public static Filter cipher(XFunction<? super Boolean, ? extends Cipher> ciphers) {
        Objects.requireNonNull(ciphers);
        return new CipherFilter((XSupplier<Cipher>)((XSupplier)() -> (Cipher)ciphers.apply((Object)false)), (XSupplier<Cipher>)((XSupplier)() -> (Cipher)ciphers.apply((Object)true)));
    }

    public static Filter deflate() {
        return BIOS.deflate(-1);
    }

    public static Filter deflate(int level) {
        if (level < -1 || 9 < level) {
            throw new IllegalArgumentException(level + " is not in the range from " + -1 + " to " + 9 + ".");
        }
        return BIOS.deflate((XSupplier<Deflater>)((XSupplier)() -> new Deflater(level)), (XSupplier<Inflater>)((XSupplier)Inflater::new));
    }

    public static Filter deflate(XSupplier<Deflater> deflaterSupplier, XSupplier<Inflater> inflaterSupplier) {
        return new DeflateFilter(Objects.requireNonNull(deflaterSupplier), Objects.requireNonNull(inflaterSupplier));
    }

    public static Filter gzip() {
        return new GZIPFilter();
    }

    public static Filter identity() {
        return Filter.IDENTITY;
    }

    public static Filter inflate() {
        return BIOS.inflate(-1);
    }

    public static Filter inflate(int level) {
        if (level < -1 || 9 < level) {
            throw new IllegalArgumentException(level + " is not in the range from " + -1 + " to " + 9 + ".");
        }
        return BIOS.inflate((XSupplier<Inflater>)((XSupplier)Inflater::new), (XSupplier<Deflater>)((XSupplier)() -> new Deflater(level)));
    }

    public static Filter inflate(XSupplier<Inflater> inflaterSupplier, XSupplier<Deflater> deflaterSupplier) {
        return new InflateFilter(Objects.requireNonNull(inflaterSupplier), Objects.requireNonNull(deflaterSupplier));
    }

    public static Source resource(String name) {
        return BIOS.resource(name, Thread.currentThread().getContextClassLoader());
    }

    public static Source resource(String name, ClassLoader cl) {
        return () -> () -> Optional.ofNullable(null == cl ? ClassLoader.getSystemResourceAsStream(name) : cl.getResourceAsStream(name)).orElseThrow(() -> new FileNotFoundException(name));
    }

    public static Source stdin() {
        return BIOS.stream(System.in);
    }

    public static Source stream(InputStream in) {
        Objects.requireNonNull(in);
        return () -> () -> new UncloseableInputStream(in);
    }

    public static Source url(URL url) {
        Objects.requireNonNull(url);
        return () -> url::openStream;
    }

    public static Sink stderr() {
        return BIOS.stream(System.err);
    }

    public static Sink stdout() {
        return BIOS.stream(System.out);
    }

    public static Sink stream(OutputStream out) {
        Objects.requireNonNull(out);
        return () -> () -> new UncloseableOutputStream(out);
    }

    public static FileStore file(File path) {
        return BIOS.file(path, false);
    }

    public static FileStore file(File path, boolean append) {
        return BIOS.file(path.toPath(), append);
    }

    public static FileStore file(Path path) {
        return BIOS.file(path, false);
    }

    public static FileStore file(Path path, boolean append) {
        RealPathStore store = new RealPathStore(Objects.requireNonNull(path));
        return append ? store.onOutput(StandardOpenOption.APPEND, StandardOpenOption.CREATE) : store;
    }

    public static FileStore file(String path) {
        return BIOS.file(path, false);
    }

    public static FileStore file(String path, boolean append) {
        return BIOS.file(Paths.get(path, new String[0]), append);
    }

    public static Store memory() {
        return BIOS.memory(8192);
    }

    public static Store memory(int bufferSize) {
        return new MemoryStore(bufferSize);
    }

    public static PathStore path(Path p) {
        return BIOS.path(p, false);
    }

    public static PathStore path(Path p, boolean append) {
        return BIOS.file(p, append);
    }

    public static Store preferences(Preferences p, String key) {
        return new PreferencesStore(Objects.requireNonNull(p), Objects.requireNonNull(key));
    }

    public static Store systemPreferences(Class<?> classInPackage, String key) {
        return BIOS.preferences(Preferences.systemNodeForPackage(classInPackage), key);
    }

    public static Store userPreferences(Class<?> classInPackage, String key) {
        return BIOS.preferences(Preferences.userNodeForPackage(classInPackage), key);
    }

    public static ArchiveStore directory(File path) {
        return BIOS.directory(path.toPath());
    }

    public static ArchiveStore directory(Path path) {
        return new DirectoryStore(Objects.requireNonNull(path));
    }

    public static ArchiveStore directory(String path) {
        return BIOS.directory(Paths.get(path, new String[0]));
    }

    public static ArchiveStore jar(final File path) {
        Objects.requireNonNull(path);
        return new ArchiveStore(){

            public Socket<ArchiveInputStream> input() {
                return () -> new ZipFileAdapter(new ZipFile(path));
            }

            public Socket<ArchiveOutputStream> output() {
                return () -> new JarOutputStreamAdapter(new JarOutputStream(new FileOutputStream(path)));
            }
        };
    }

    public static ArchiveStore jar(String path) {
        return BIOS.jar(new File(path));
    }

    public static ArchiveStore zip(final File path) {
        Objects.requireNonNull(path);
        return new ArchiveStore(){

            public Socket<ArchiveInputStream> input() {
                return () -> new ZipFileAdapter(new ZipFile(path));
            }

            public Socket<ArchiveOutputStream> output() {
                return () -> new ZipOutputStreamAdapter(new ZipOutputStream(new FileOutputStream(path)));
            }
        };
    }

    public static ArchiveStore zip(String path) {
        return BIOS.zip(new File(path));
    }

    public static void copy(ArchiveSource source, ArchiveSink sink) throws Exception {
        Copy.copy((ArchiveSource)source, (ArchiveSink)sink);
    }

    public static void copy(Source source, Sink sink) throws Exception {
        Copy.copy((Source)source, (Sink)sink);
    }

    public static void copy(Socket<? extends InputStream> input, Socket<? extends OutputStream> output) throws Exception {
        Copy.copy(input, output);
    }

    public static <T extends Serializable> T clone(T t) throws Exception {
        return BIOS.clone(t, 8192);
    }

    public static <T extends Serializable> T clone(T t, int bufferSize) throws Exception {
        return (T)((Serializable)BIOS.serialization().connect(BIOS.memory(bufferSize)).clone(t));
    }

    public static byte[] content(Source source) throws Exception {
        return BIOS.content(source, Integer.MAX_VALUE);
    }

    public static byte[] content(Source source, int max) throws Exception {
        if (source instanceof Store) {
            return ((Store)source).content(max);
        }
        Store memory = BIOS.memory();
        BIOS.copy(source, (Sink)memory);
        return memory.content(max);
    }

    public static interface PathStore
    extends Store {
        public PathStore onInput(OpenOption ... var1);

        public PathStore onOutput(OpenOption ... var1);
    }

    public static interface FileStore
    extends PathStore {
        @Override
        public FileStore onInput(OpenOption ... var1);

        @Override
        public FileStore onOutput(OpenOption ... var1);
    }
}

