/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

import global.namespace.fun.io.api.ArchiveEntrySink;
import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveInputStream;
import global.namespace.fun.io.api.ArchiveOutputStream;
import global.namespace.fun.io.api.ArchiveStore;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import global.namespace.fun.io.spi.Copy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Optional;

final class DirectoryStore
implements ArchiveStore {
    private final Path directory;
    private final String separator;

    DirectoryStore(Path directory) {
        this.directory = directory;
        FileSystem fs = directory.getFileSystem();
        this.separator = fs.getSeparator();
    }

    public Socket<ArchiveInputStream> input() {
        return () -> new ArchiveInputStream(){

            public Iterator<ArchiveEntrySource> iterator() {
                try {
                    return Files.walk(DirectoryStore.this.directory, new FileVisitOption[0]).filter(p -> !p.equals(DirectoryStore.this.directory)).map(this::source).iterator();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public Optional<ArchiveEntrySource> source(String name) {
                Path path = DirectoryStore.this.resolve(name);
                return Optional.ofNullable(Files.exists(path, new LinkOption[0]) ? this.source(path) : null);
            }

            ArchiveEntrySource source(final Path path) {
                return new ArchiveEntrySource(){
                    final String name;
                    {
                        this.name = DirectoryStore.this.relativize(path);
                    }

                    public Socket<InputStream> input() {
                        return () -> {
                            if (this.directory()) {
                                return new ByteArrayInputStream(new byte[0]);
                            }
                            return Files.newInputStream(path, new OpenOption[0]);
                        };
                    }

                    public String name() {
                        return this.directory() ? this.name + '/' : this.name;
                    }

                    public boolean directory() {
                        return Files.isDirectory(path, new LinkOption[0]);
                    }

                    public long size() {
                        try {
                            return Files.size(path);
                        }
                        catch (IOException ignored) {
                            return 0L;
                        }
                    }
                };
            }

            public void close() {
            }
        };
    }

    public Socket<ArchiveOutputStream> output() {
        return () -> new ArchiveOutputStream(){

            public ArchiveEntrySink sink(String name) {
                return this.sink(DirectoryStore.this.resolve(name));
            }

            ArchiveEntrySink sink(final Path path) {
                return new ArchiveEntrySink(){

                    public Socket<OutputStream> output() {
                        return () -> {
                            Path parent = path.getParent();
                            if (null != parent) {
                                Files.createDirectories(parent, new FileAttribute[0]);
                            }
                            return Files.newOutputStream(path, new OpenOption[0]);
                        };
                    }

                    public void copyFrom(ArchiveEntrySource source) throws Exception {
                        if (source.directory()) {
                            Files.createDirectories(path, new FileAttribute[0]);
                        } else {
                            Copy.copy((Source)source, (Sink)this);
                        }
                    }
                };
            }

            public void close() {
            }
        };
    }

    private Path resolve(String name) {
        return this.directory.resolve(ArchiveEntryNames.requireInternal((String)name).replace("/", this.separator));
    }

    private String relativize(Path path) {
        return this.directory.relativize(path).toString().replace(this.separator, "/");
    }
}

