/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

import global.namespace.fun.io.api.Filter;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.function.XSupplier;
import global.namespace.fun.io.bios.SideEffect;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;

final class InflateFilter
implements Filter {
    private final XSupplier<Inflater> inflaterSupplier;
    private final XSupplier<Deflater> deflaterSupplier;

    InflateFilter(XSupplier<Inflater> inflaterSupplier, XSupplier<Deflater> deflaterSupplier) {
        this.inflaterSupplier = inflaterSupplier;
        this.deflaterSupplier = deflaterSupplier;
    }

    public Socket<OutputStream> output(Socket<OutputStream> output) {
        return output.map(out -> new InflaterOutputStream((OutputStream)out, (Inflater)this.inflaterSupplier.get(), 8192){
            boolean closed;

            @Override
            public void close() throws IOException {
                this.finish();
                if (!this.closed) {
                    this.closed = true;
                    SideEffect.runAll(this.inf::end, () -> super.close());
                }
            }
        });
    }

    public Socket<InputStream> input(Socket<InputStream> input) {
        return input.map(in -> new DeflaterInputStream((InputStream)in, (Deflater)this.deflaterSupplier.get(), 8192){
            boolean closed;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    SideEffect.runAll(this.def::end, () -> super.close());
                }
            }
        });
    }
}

