/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

import global.namespace.fun.io.api.ContentTooLargeException;
import global.namespace.fun.io.api.NoContentException;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalLong;

final class MemoryStore
implements Store {
    private final int bufferSize;
    private Optional<byte[]> optContent = Optional.empty();

    MemoryStore(int bufferSize) {
        this.bufferSize = bufferSize;
        if (0 > this.bufferSize) {
            throw new IllegalArgumentException(bufferSize + " is a negative buffer size.");
        }
    }

    public Socket<InputStream> input() {
        return () -> new ByteArrayInputStream(this.checkedContent());
    }

    public Socket<OutputStream> output() {
        return () -> new ByteArrayOutputStream(this.bufferSize){

            @Override
            public void close() throws IOException {
                MemoryStore.this.content(this.toByteArray());
            }
        };
    }

    public void delete() throws IOException {
        this.checkedContent();
        this.optContent = Optional.empty();
    }

    public OptionalLong size() throws IOException {
        return this.optContent.map(bytes -> OptionalLong.of(((byte[])bytes).length)).orElseGet(OptionalLong::empty);
    }

    public boolean exists() {
        return this.optContent.isPresent();
    }

    private byte[] checkedContent() throws NoContentException {
        return this.optContent.orElseThrow(NoContentException::new);
    }

    public byte[] content(int max) throws IOException {
        if (max < 0) {
            throw new IllegalArgumentException(max + " < 0");
        }
        Optional<byte[]> optContent = this.optContent;
        if (optContent.isPresent()) {
            byte[] content = optContent.get();
            int length = content.length;
            if (length <= max) {
                return (byte[])content.clone();
            }
            throw new ContentTooLargeException((long)length, max);
        }
        throw new NoContentException();
    }

    public void content(byte[] b, int off, int len) throws IOException {
        this.optContent = Optional.of(Arrays.copyOfRange(b, off, off + len));
    }
}

