/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

import global.namespace.fun.io.api.ContentTooLargeException;
import global.namespace.fun.io.api.NoContentException;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

final class PreferencesStore
implements Store {
    private final Preferences prefs;
    private final String key;

    PreferencesStore(Preferences p, String key) {
        this.prefs = p;
        this.key = key;
    }

    public Socket<InputStream> input() {
        return () -> new ByteArrayInputStream(this.content());
    }

    public Socket<OutputStream> output() {
        return () -> new ByteArrayOutputStream(8192){

            @Override
            public void close() throws IOException {
                PreferencesStore.this.content(this.toByteArray());
            }
        };
    }

    public void delete() throws IOException {
        this.content();
        this.prefs.remove(this.key);
        this.sync();
    }

    public OptionalLong size() throws IOException {
        return this.optContent().map(bytes -> OptionalLong.of(((byte[])bytes).length)).orElseGet(OptionalLong::empty);
    }

    public byte[] content(int max) throws IOException {
        if (max < 0) {
            throw new IllegalArgumentException(max + " < 0");
        }
        Optional<byte[]> optContent = this.optContent();
        if (optContent.isPresent()) {
            byte[] content = optContent.get();
            int length = content.length;
            if (length <= max) {
                return content;
            }
            throw new ContentTooLargeException((long)length, max);
        }
        throw new NoContentException(String.format(Locale.ENGLISH, "Cannot locate the key \"%s\" in the %s preferences node for the absolute path \"%s\".", this.key, this.prefs.isUserNode() ? "user" : "system", this.prefs.absolutePath()));
    }

    public void content(byte[] b) throws IOException {
        this.prefs.putByteArray(this.key, b);
        this.sync();
    }

    public void content(byte[] b, int off, int len) throws IOException {
        this.content(Arrays.copyOfRange(b, off, off + len));
    }

    private Optional<byte[]> optContent() {
        return Optional.ofNullable(this.prefs.getByteArray(this.key, null));
    }

    private void sync() throws IOException {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e);
        }
    }
}

