/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.bios.BIOS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.OptionalLong;

final class RealPathStore
implements BIOS.FileStore,
BIOS.PathStore {
    private static final OpenOption[] EMPTY = new OpenOption[0];
    private final Path path;
    private final OpenOption[] inputOptions;
    private final OpenOption[] outputOptions;

    RealPathStore(Path p) {
        this(p, EMPTY, EMPTY);
    }

    private RealPathStore(Path p, OpenOption[] inputOptions, OpenOption[] outputOptions) {
        this.path = p;
        this.inputOptions = inputOptions;
        this.outputOptions = outputOptions;
    }

    @Override
    public RealPathStore onInput(OpenOption ... inputOptions) {
        return new RealPathStore(this.path, inputOptions, this.outputOptions);
    }

    @Override
    public RealPathStore onOutput(OpenOption ... outputOptions) {
        return new RealPathStore(this.path, this.inputOptions, outputOptions);
    }

    public Socket<InputStream> input() {
        return () -> Files.newInputStream(this.path, this.inputOptions);
    }

    public Socket<OutputStream> output() {
        return () -> Files.newOutputStream(this.path, this.outputOptions);
    }

    public void deleteIfExists() throws IOException {
        Files.deleteIfExists(this.path);
    }

    public void delete() throws IOException {
        Files.delete(this.path);
    }

    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public OptionalLong size() throws IOException {
        try {
            return OptionalLong.of(Files.size(this.path));
        }
        catch (NoSuchFileException ignored) {
            return OptionalLong.empty();
        }
    }
}

