/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

@FunctionalInterface
interface SideEffect<X extends Exception> {
    @SafeVarargs
    public static <X extends Exception> void runAll(SideEffect<X> first, SideEffect<X> ... others) throws X {
        SideEffect<X> acc = first;
        for (SideEffect<X> other : others) {
            acc = acc.andThen(other);
        }
        acc.run();
    }

    public void run() throws X;

    default public <Y extends X> SideEffect<X> andThen(SideEffect<Y> that) {
        return () -> {
            Throwable t1 = null;
            try {
                this.run();
            }
            catch (Throwable t) {
                t1 = t;
                throw t;
            }
            finally {
                try {
                    that.run();
                }
                catch (Throwable t) {
                    if (null == t1) {
                        throw t;
                    }
                    t1.addSuppressed(t);
                }
            }
        };
    }
}

