/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

import global.namespace.fun.io.api.Codec;
import global.namespace.fun.io.api.Decoder;
import global.namespace.fun.io.api.Encoder;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.function.XFunction;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;

final class XMLCodec
implements Codec {
    private final XFunction<? super OutputStream, ? extends XMLEncoder> xmlEncoders;
    private final XFunction<? super InputStream, ? extends XMLDecoder> xmlDecoders;

    XMLCodec(XFunction<? super OutputStream, ? extends XMLEncoder> xmlEncoders, XFunction<? super InputStream, ? extends XMLDecoder> xmlDecoders) {
        this.xmlEncoders = xmlEncoders;
        this.xmlDecoders = xmlDecoders;
    }

    public Encoder encoder(Socket<OutputStream> output) {
        return obj -> {
            ZeroToleranceListener ztl = new ZeroToleranceListener();
            output.map(this.xmlEncoders).accept(enc -> {
                enc.setExceptionListener(ztl);
                enc.writeObject(obj);
            });
            ztl.check();
        };
    }

    public Decoder decoder(final Socket<InputStream> input) {
        return new Decoder(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T> T decode(Type expected) throws Exception {
                ZeroToleranceListener ztl = new ZeroToleranceListener();
                try {
                    Object object = input.map(XMLCodec.this.xmlDecoders).apply(dec -> {
                        dec.setExceptionListener(ztl);
                        return dec.readObject();
                    });
                    return (T)object;
                }
                finally {
                    ztl.check();
                }
            }
        };
    }

    private static class ZeroToleranceListener
    implements ExceptionListener {
        Exception e;

        private ZeroToleranceListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            if (null == this.e) {
                this.e = e;
            }
        }

        void check() throws Exception {
            if (null != this.e) {
                throw this.e;
            }
        }
    }
}

