/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveInputStream;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class ZipFileAdapter
implements ArchiveInputStream {
    private final ZipFile zip;

    ZipFileAdapter(ZipFile input) {
        this.zip = Objects.requireNonNull(input);
    }

    public Iterator<ArchiveEntrySource> iterator() {
        return new Iterator<ArchiveEntrySource>(){
            final Enumeration<? extends ZipEntry> en;
            ZipEntry next;
            {
                this.en = ZipFileAdapter.this.zip.entries();
            }

            @Override
            public boolean hasNext() {
                if (null != this.next) {
                    return true;
                }
                while (this.en.hasMoreElements()) {
                    ZipEntry entry = this.en.nextElement();
                    if (!ArchiveEntryNames.isInternal((String)entry.getName())) continue;
                    this.next = entry;
                    return true;
                }
                return false;
            }

            @Override
            public ArchiveEntrySource next() {
                if (this.hasNext()) {
                    ZipEntry entry = this.next;
                    this.next = null;
                    return ZipFileAdapter.this.source(entry);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Optional<ArchiveEntrySource> source(String name) {
        return Optional.ofNullable(this.zip.getEntry(ArchiveEntryNames.requireInternal((String)name))).map(this::source);
    }

    private ArchiveEntrySource source(final ZipEntry entry) {
        return new ArchiveEntrySource(){

            public Socket<InputStream> input() {
                return () -> ZipFileAdapter.this.zip.getInputStream(entry);
            }

            public String name() {
                return entry.getName();
            }

            public boolean directory() {
                return entry.isDirectory();
            }

            public long size() {
                return entry.getSize();
            }
        };
    }

    public void close() throws IOException {
        this.zip.close();
    }
}

