/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.bios;

import global.namespace.fun.io.api.ArchiveEntrySink;
import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveOutputStream;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import global.namespace.fun.io.spi.Copy;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class ZipOutputStreamAdapter
implements ArchiveOutputStream {
    private final ZipOutputStream zip;

    ZipOutputStreamAdapter(ZipOutputStream zip) {
        this.zip = Objects.requireNonNull(zip);
    }

    public ArchiveEntrySink sink(String name) {
        return this.sink(new ZipEntry(ArchiveEntryNames.requireInternal((String)name)));
    }

    ArchiveEntrySink sink(final ZipEntry entry) {
        return new ArchiveEntrySink(){

            public Socket<OutputStream> output() {
                return () -> {
                    if (entry.isDirectory()) {
                        entry.setMethod(0);
                        entry.setSize(0L);
                        entry.setCompressedSize(0L);
                        entry.setCrc(0L);
                    }
                    ZipOutputStreamAdapter.this.zip.putNextEntry(entry);
                    return new FilterOutputStream(ZipOutputStreamAdapter.this.zip){

                        @Override
                        public void close() throws IOException {
                            ZipOutputStreamAdapter.this.zip.closeEntry();
                        }
                    };
                };
            }

            public void copyFrom(ArchiveEntrySource source) throws Exception {
                Copy.copy((Source)source, (Sink)this);
            }
        };
    }

    public void close() throws IOException {
        this.zip.close();
    }
}

