/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.service.wight.annotation.processing;

import global.namespace.service.wight.annotation.ServiceInterface;
import global.namespace.service.wight.annotation.processing.ServiceAnnnotationProcessor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"global.namespace.service.wight.annotation.ServiceInterface"})
public final class ServiceInterfaceProcessor
extends ServiceAnnnotationProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceInterface.class)) {
            if (element instanceof TypeElement) {
                this.valid((TypeElement)element);
                continue;
            }
            this.warning("Expected a type element here.", element);
        }
        return true;
    }

    private void valid(TypeElement iface) {
        Set<Modifier> modifiers = iface.getModifiers();
        if (!modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.FINAL)) {
            this.error("Not a public and non-final class or interface.", iface);
            return;
        }
        if (iface.getNestingKind().isNested()) {
            if (!modifiers.contains((Object)Modifier.STATIC)) {
                this.error("Impossible to implement outside of the lexical scope of the enclosing class.", iface);
                return;
            }
            this.warning("Bad practice: Not a top-level class or interface.", iface);
        }
        LinkedList<ExecutableElement> constructors = new LinkedList<ExecutableElement>();
        for (Element element : iface.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            constructors.add((ExecutableElement)element);
        }
        if (!constructors.isEmpty() && !this.valid(constructors)) {
            this.error("No public or protected constructor with zero parameters available.", iface);
        }
    }

    private boolean valid(Collection<ExecutableElement> constructors) {
        for (ExecutableElement ctor : constructors) {
            if (!this.valid(ctor)) continue;
            return true;
        }
        return false;
    }

    private boolean valid(ExecutableElement ctor) {
        return (ctor.getModifiers().contains((Object)Modifier.PUBLIC) || ctor.getModifiers().contains((Object)Modifier.PROTECTED)) && ctor.getParameters().isEmpty();
    }
}

