/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.PaddingException;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.StandardImageTiler;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.LoggerHelper;
import nom.tam.util.RandomAccess;
import nom.tam.util.array.MultiArrayIterator;
import nom.tam.util.type.PrimitiveType;
import nom.tam.util.type.PrimitiveTypeHandler;

public class ImageData
extends Data {
    private static final Logger LOG = LoggerHelper.getLogger(ImageData.class);
    private long byteSize;
    private Object dataArray;
    private ArrayDesc dataDescription;
    private StandardImageTiler tiler;

    public ImageData() {
        this.dataArray = new byte[0];
        this.byteSize = 0L;
    }

    public ImageData(Header h) throws FitsException {
        this.dataDescription = this.parseHeader(h);
    }

    public ImageData(Object x) {
        this.dataArray = x;
        this.byteSize = ArrayFuncs.computeLSize(x);
    }

    @Override
    protected void fillHeader(Header head) throws FitsException {
        int bitpix;
        if (this.dataArray == null) {
            head.nullImage();
            return;
        }
        Standard.context(ImageData.class);
        String classname = this.dataArray.getClass().getName();
        int[] dimens = ArrayFuncs.getDimensions(this.dataArray);
        if (dimens == null || dimens.length == 0) {
            throw new FitsException("Image data object not array");
        }
        switch (classname.charAt(dimens.length)) {
            case 'B': {
                bitpix = 8;
                break;
            }
            case 'S': {
                bitpix = 16;
                break;
            }
            case 'I': {
                bitpix = 32;
                break;
            }
            case 'J': {
                bitpix = 64;
                break;
            }
            case 'F': {
                bitpix = -32;
                break;
            }
            case 'D': {
                bitpix = -64;
                break;
            }
            default: {
                throw new FitsException("Invalid Object Type for FITS data:" + classname.charAt(dimens.length));
            }
        }
        head.setSimple(true);
        head.setBitpix(bitpix);
        head.setNaxes(dimens.length);
        for (int i = 1; i <= dimens.length; ++i) {
            if (dimens[i - 1] == -1) {
                throw new FitsException("Unfilled array for dimension: " + i);
            }
            head.setNaxis(i, dimens[dimens.length - i]);
        }
        head.addValue((IFitsHeader)Standard.EXTEND, true);
        head.addValue((IFitsHeader)Standard.PCOUNT, 0);
        head.addValue((IFitsHeader)Standard.GCOUNT, 1);
        Standard.context(null);
    }

    @Override
    public Object getData() {
        if (this.dataArray == null && this.tiler != null) {
            try {
                this.dataArray = this.tiler.getCompleteImage();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Unable to get complete image", e);
                return null;
            }
        }
        return this.dataArray;
    }

    public StandardImageTiler getTiler() {
        return this.tiler;
    }

    @Override
    protected long getTrueSize() {
        return this.byteSize;
    }

    protected ArrayDesc parseHeader(Header h) throws FitsException {
        int gCount = h.getIntValue(Standard.GCOUNT, 1);
        int pCount = h.getIntValue(Standard.PCOUNT, 0);
        if (gCount > 1 || pCount != 0) {
            throw new FitsException("Group data treated as images");
        }
        int bitPix = h.getIntValue(Standard.BITPIX, 0);
        PrimitiveType<Buffer> primitivType = PrimitiveTypeHandler.valueOf(bitPix);
        Class<?> baseClass = primitivType.primitiveClass();
        int ndim = h.getIntValue(Standard.NAXIS, 0);
        int[] dims = new int[ndim];
        this.byteSize = 1L;
        for (int i = 0; i < ndim; ++i) {
            int cdim = h.getIntValue(Standard.NAXISn.n(i + 1), 0);
            if (cdim < 0) {
                throw new FitsException("Invalid array dimension:" + cdim);
            }
            this.byteSize *= (long)cdim;
            dims[ndim - i - 1] = cdim;
        }
        this.byteSize *= (long)primitivType.size();
        if (ndim == 0) {
            this.byteSize = 0L;
        }
        return new ArrayDesc(dims, baseClass);
    }

    @Override
    public void read(ArrayDataInput i) throws FitsException {
        if (this.byteSize == 0L) {
            return;
        }
        this.setFileOffset(i);
        if (i instanceof RandomAccess) {
            this.tiler = new ImageDataTiler((RandomAccess)i, ((RandomAccess)i).getFilePointer(), this.dataDescription);
            try {
                i.skipAllBytes(this.byteSize);
            }
            catch (IOException e) {
                throw new FitsException("Unable to skip over image:" + e);
            }
        }
        this.dataArray = ArrayFuncs.newInstance(this.dataDescription.type, this.dataDescription.dims);
        try {
            i.readLArray(this.dataArray);
        }
        catch (IOException e) {
            throw new FitsException("Unable to read image data:" + e);
        }
        this.tiler = new ImageDataTiler(null, 0L, this.dataDescription);
        int pad = FitsUtil.padding(this.getTrueSize());
        try {
            i.skipAllBytes(pad);
        }
        catch (EOFException e) {
            throw new PaddingException("Error skipping padding after image", this, e);
        }
        catch (IOException e) {
            throw new FitsException("Error skipping padding after image", e);
        }
    }

    public void setBuffer(Buffer data) {
        PrimitiveType<Buffer> primType = PrimitiveTypeHandler.valueOf(this.dataDescription.type);
        this.dataArray = ArrayFuncs.newInstance(this.dataDescription.type, this.dataDescription.dims);
        MultiArrayIterator iterator = new MultiArrayIterator(this.dataArray);
        Object array = iterator.next();
        while (array != null) {
            primType.getArray(data, array);
            array = iterator.next();
        }
    }

    void setTiler(StandardImageTiler tiler) {
        this.tiler = tiler;
    }

    @Override
    public void write(ArrayDataOutput o) throws FitsException {
        if (this.byteSize == 0L) {
            return;
        }
        if (this.dataArray == null) {
            if (this.tiler != null) {
                try {
                    this.dataArray = this.tiler.getCompleteImage();
                }
                catch (IOException e) {
                    throw new FitsException("Error attempting to fill image", e);
                }
            } else if (this.dataArray == null && this.dataDescription != null) {
                this.dataArray = ArrayFuncs.newInstance(this.dataDescription.type, this.dataDescription.dims);
            } else {
                throw new FitsException("Null image data");
            }
        }
        try {
            o.writeArray(this.dataArray);
        }
        catch (IOException e) {
            throw new FitsException("IO Error on image write" + e);
        }
        FitsUtil.pad(o, this.getTrueSize());
    }

    protected class ImageDataTiler
    extends StandardImageTiler {
        ImageDataTiler(RandomAccess o, long offset, ArrayDesc d) {
            super(o, offset, d.dims, d.type);
        }

        @Override
        protected Object getMemoryImage() {
            return ImageData.this.dataArray;
        }
    }

    protected static class ArrayDesc {
        private final int[] dims;
        private final Class<?> type;

        ArrayDesc(int[] dims, Class<?> type) {
            this.dims = dims;
            this.type = type;
        }
    }
}

