/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header.extra;

import nom.tam.fits.header.FitsHeaderImpl;
import nom.tam.fits.header.IFitsHeader;

public enum SBFitsExt implements IFitsHeader
{
    APTAREA(IFitsHeader.VALUE.REAL, "Aperture Area of the Telescope"),
    APTDIA(IFitsHeader.VALUE.REAL, "Aperture Diameter of the Telescope"),
    CBLACK(IFitsHeader.VALUE.INTEGER, "use this ADU level for the Black"),
    CCD_TEMP("CCD-TEMP", IFitsHeader.VALUE.REAL, "Temperature of CCD"),
    CENTALT(IFitsHeader.VALUE.STRING, "Altitude of the center of the image"),
    CENTAZ(IFitsHeader.VALUE.STRING, "Azimuth of the center of the image"),
    CWHITE(IFitsHeader.VALUE.INTEGER, "use this ADU level for the White"),
    DARKTIME(IFitsHeader.VALUE.REAL, "Dark time"),
    EGAIN(IFitsHeader.VALUE.REAL, "Electronic gain in e-/ADU"),
    FOCALLEN(IFitsHeader.VALUE.REAL, "Focal Length of the Telescope"),
    IMAGETYP(IFitsHeader.VALUE.STRING, "type of image"),
    OBJCTDEC(IFitsHeader.VALUE.STRING, "Declination of the center of the image"),
    OBJCTRA(IFitsHeader.VALUE.STRING, "Right Ascension of the center of the image"),
    PEDESTAL(IFitsHeader.VALUE.INTEGER, "ADU count to each pixel value to get to a zero"),
    SBSTDVER(IFitsHeader.VALUE.STRING, "version of this standard"),
    SET_TEMP("SET-TEMP", IFitsHeader.VALUE.REAL, "setpoint of the cooling in degrees C"),
    SITELAT(IFitsHeader.VALUE.STRING, "Latitude of the imaging location"),
    SITELONG(IFitsHeader.VALUE.STRING, "Longitude of the imaging location"),
    SNAPSHOT(IFitsHeader.VALUE.INTEGER, "Number of images combined"),
    SWCREATE(IFitsHeader.VALUE.STRING, "created version of the Software"),
    SWMODIFY(IFitsHeader.VALUE.STRING, "modified version of the Software"),
    TRAKTIME(IFitsHeader.VALUE.REAL, "exposure time in seconds of the tracker"),
    XBINNING(IFitsHeader.VALUE.INTEGER, "Binning factor in width"),
    XORGSUBF(IFitsHeader.VALUE.INTEGER, "Sub frame X position"),
    XPIXSZ(IFitsHeader.VALUE.REAL, "Pixel width in microns"),
    YBINNING(IFitsHeader.VALUE.INTEGER, "Binning factor in height"),
    YORGSUBF(IFitsHeader.VALUE.INTEGER, "Sub frame Y position"),
    YPIXSZ(IFitsHeader.VALUE.REAL, "Pixel height in microns");

    private final IFitsHeader key;

    private SBFitsExt(String key, IFitsHeader.VALUE valueType, String comment) {
        this.key = new FitsHeaderImpl(key, IFitsHeader.SOURCE.SBIG, IFitsHeader.HDU.IMAGE, valueType, comment);
    }

    private SBFitsExt(IFitsHeader.VALUE valueType, String comment) {
        this.key = new FitsHeaderImpl(this.name(), IFitsHeader.SOURCE.SBIG, IFitsHeader.HDU.IMAGE, valueType, comment);
    }

    @Override
    public String comment() {
        return this.key.comment();
    }

    @Override
    public IFitsHeader.HDU hdu() {
        return this.key.hdu();
    }

    @Override
    public String key() {
        return this.key.key();
    }

    @Override
    public IFitsHeader n(int ... number) {
        return this.key.n(number);
    }

    @Override
    public IFitsHeader.SOURCE status() {
        return this.key.status();
    }

    @Override
    public IFitsHeader.VALUE valueType() {
        return this.key.valueType();
    }
}

