/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.array;

import java.lang.reflect.Array;

public class MultiArrayPointer {
    public static final Object END = new Object();
    private Object array;
    private int index;
    private int length;
    private MultiArrayPointer sub;
    private MultiArrayPointer backup;

    public static boolean isSubArray(Object element) {
        Class<?> elementClazz = element.getClass();
        boolean isArray = elementClazz.isArray();
        if (isArray && Object.class.equals(elementClazz.getComponentType())) {
            int length = Array.getLength(element);
            for (int index = 0; index < length; ++index) {
                Object subElement = Array.get(element, index);
                if (subElement == null) continue;
                return subElement.getClass().isArray();
            }
            return false;
        }
        return isArray && elementClazz.getComponentType().isArray();
    }

    public MultiArrayPointer() {
    }

    public MultiArrayPointer(Object baseArray) {
        this.set(baseArray);
    }

    private void activateSub(Object element) {
        if (this.backup == null) {
            this.backup = new MultiArrayPointer();
        }
        this.sub = this.backup;
        this.sub.set(element);
    }

    private void deactivateSub() {
        this.sub = null;
    }

    public Object next() {
        Object element;
        while (true) {
            if (this.sub != null) {
                Object subNext = this.sub.next();
                if (subNext != END) {
                    return subNext;
                }
                this.deactivateSub();
            }
            if (this.index >= this.length) {
                return END;
            }
            if ((element = Array.get(this.array, this.index++)) == null || !MultiArrayPointer.isSubArray(element)) break;
            this.activateSub(element);
        }
        return element;
    }

    public void reset() {
        this.index = 0;
        this.deactivateSub();
    }

    private void set(Object newArray) {
        this.array = newArray;
        this.length = Array.getLength(this.array);
        this.sub = null;
        this.index = 0;
    }
}

