/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.DataStoreProducer;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDataStoreProducer
extends WWObjectImpl
implements DataStoreProducer {
    private AVList params;
    private List<SourceInfo> dataSourceList = Collections.synchronizedList(new ArrayList());
    private List<Object> productionResults = new ArrayList<Object>();
    private boolean isStopped = false;
    protected AVList productionParams = null;

    @Override
    public AVList getProductionParameters() {
        return this.productionParams;
    }

    @Override
    public AVList getStoreParameters() {
        return this.params;
    }

    @Override
    public void setStoreParameters(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateProductionParameters(aVList);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.params = aVList;
    }

    @Override
    public Iterable<Object> getDataSources() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (SourceInfo sourceInfo : this.dataSourceList) {
            arrayList.add(sourceInfo.source);
        }
        return arrayList;
    }

    @Override
    public boolean acceptsDataSource(Object object, AVList aVList) {
        if (object == null || this.isStopped()) {
            return false;
        }
        String string = this.validateDataSource(object, aVList);
        return string == null;
    }

    @Override
    public boolean containsDataSource(Object object) {
        for (SourceInfo sourceInfo : this.dataSourceList) {
            if (!(sourceInfo.source != null ? sourceInfo.source.equals(object) : object == null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void offerDataSource(Object object, AVList aVList) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateDataSource(object, aVList = null == aVList ? new AVListImpl() : aVList.copy());
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dataSourceList.add(new SourceInfo(object, aVList));
    }

    @Override
    public void offerAllDataSources(Iterable<?> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Object obj : iterable) {
            this.offerDataSource(obj, null);
        }
    }

    @Override
    public void removeDataSource(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            return;
        }
        Iterator<SourceInfo> iterator = this.dataSourceList.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        SourceInfo sourceInfo = iterator.next();
        while (iterator.hasNext()) {
            if (sourceInfo.source != null && sourceInfo.source.equals(object)) {
                iterator.remove();
            }
            sourceInfo = iterator.next();
        }
    }

    @Override
    public void removeAllDataSources() {
        this.dataSourceList.clear();
    }

    @Override
    public void startProduction() throws Exception {
        if (this.isStopped()) {
            String string = Logging.getMessage("DataStoreProducer.Stopped");
            Logging.logger().warning(string);
            return;
        }
        String string = this.validateProductionParameters(this.params);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.doStartProduction(this.params);
    }

    @Override
    public synchronized void stopProduction() {
        this.isStopped = true;
    }

    protected synchronized boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public Iterable<?> getProductionResults() {
        return Collections.unmodifiableList(this.productionResults);
    }

    @Override
    public void removeProductionState() {
    }

    protected List<SourceInfo> getDataSourceList() {
        return this.dataSourceList;
    }

    protected List<Object> getProductionResultsList() {
        return this.productionResults;
    }

    protected abstract void doStartProduction(AVList var1) throws Exception;

    protected abstract String validateProductionParameters(AVList var1);

    protected abstract String validateDataSource(Object var1, AVList var2);

    public static class SourceInfo
    extends AVListImpl {
        public Object source;

        public SourceInfo(Object object, AVList aVList) {
            this.source = object;
            if (null != aVList) {
                this.setValues(aVList);
            }
        }
    }
}

