/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ElevationsUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;

public class BILRasterReader
extends AbstractDataRasterReader {
    private static final String[] bilMimeTypes = new String[]{"image/bil", "application/bil", "application/bil16", "application/bil32"};
    private static final String[] bilSuffixes = new String[]{"bil", "bil16", "bil32", "bil.gz", "bil16.gz", "bil32.gz"};
    private boolean mapLargeFiles = false;
    private long largeFileThreshold = 0x1000000L;

    public BILRasterReader() {
        super(bilMimeTypes, bilSuffixes);
    }

    public boolean isMapLargeFiles() {
        return this.mapLargeFiles;
    }

    public void setMapLargeFiles(boolean bl) {
        this.mapLargeFiles = bl;
    }

    public long getLargeFileThreshold() {
        return this.largeFileThreshold;
    }

    public void setLargeFileThreshold(long l) {
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "largeFileThreshold < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.largeFileThreshold = l;
    }

    @Override
    protected boolean doCanRead(Object object, AVList aVList) {
        if (!(object instanceof File) && !(object instanceof URL)) {
            return false;
        }
        String string = this.validateMetadata(object, aVList);
        if (!WWUtil.isEmpty(string) && !WorldFile.hasWorldFiles(object)) {
            Logging.logger().fine(string);
            return false;
        }
        if (null != aVList && !aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
        }
        return true;
    }

    @Override
    protected DataRaster[] doRead(Object object, AVList aVList) throws IOException {
        ByteBuffer byteBuffer = this.readElevations(object);
        if (this.validateMetadata(object, aVList) != null) {
            aVList = aVList != null ? aVList.copy() : new AVListImpl();
            aVList.setValue("gov.nasa.worldwind.avkey.FileSize", byteBuffer.capacity());
            WorldFile.readWorldFiles(object, aVList);
        }
        int n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
        int n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
        }
        ByteBufferRaster byteBufferRaster = new ByteBufferRaster(n, n2, sector, byteBuffer, aVList);
        ElevationsUtil.rectify(byteBufferRaster);
        return new DataRaster[]{byteBufferRaster};
    }

    @Override
    protected void doReadMetadata(Object object, AVList aVList) throws IOException {
        if (this.validateMetadata(object, aVList) != null) {
            WorldFile.readWorldFiles(object, aVList);
        }
    }

    @Override
    protected String validateMetadata(Object object, AVList aVList) {
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        String string = super.validateMetadata(object, aVList);
        if (string != null) {
            stringBuilder.append(string);
        }
        Object object3 = object2 = aVList != null ? aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder") : null;
        if (object2 == null || !(object2 instanceof String)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoByteOrderSpecified", object));
        }
        Object object4 = object2 = aVList != null ? aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat") : null;
        if (object2 == null) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoPixelFormatSpecified", object));
        } else if (!"gov.nasa.worldwind.avkey.Elevation".equals(object2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.InvalidPixelFormat", object));
        }
        Object object5 = object2 = aVList != null ? aVList.getValue("gov.nasa.worldwind.avkey.DataType") : null;
        if (object2 == null) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoDataTypeSpecified", object));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private ByteBuffer readElevations(Object object) throws IOException {
        URL uRL;
        if (!(object instanceof File) && !(object instanceof URL)) {
            String string = Logging.getMessage("DataRaster.CannotRead", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File file = object instanceof File ? (File)object : null;
        URL uRL2 = uRL = object instanceof URL ? (URL)object : null;
        if (null == file && "file".equalsIgnoreCase(uRL.getProtocol())) {
            file = new File(uRL.getFile());
        }
        if (null != file) {
            if (file.getName().toLowerCase().endsWith(".zip")) {
                return WWIO.readZipEntryToBuffer(file, null);
            }
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return WWIO.readGZipFileToBuffer(file);
            }
            if (!this.isMapLargeFiles() || this.getLargeFileThreshold() > file.length()) {
                return WWIO.readFileToBuffer(file);
            }
            return WWIO.mapFile(file);
        }
        return WWIO.readURLContentToBuffer(uRL);
    }
}

