/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.gcps;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RasterControlPointList;
import gov.nasa.worldwind.util.WWIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GCPSReader {
    private String delimiter = "[\\s]";

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.DelimiterIsNullOrEmpty");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.delimiter = string;
    }

    public static File getGCPSFileFor(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return null;
        }
        String string = WWIO.replaceSuffix(file.getName(), ".gcps");
        if (file.getName().equalsIgnoreCase(string)) {
            return null;
        }
        for (File file3 : file2.listFiles()) {
            if (file3.equals(file) || !file3.getName().equalsIgnoreCase(string)) continue;
            return file3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            return false;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            RasterControlPointList rasterControlPointList = new RasterControlPointList();
            boolean bl = this.doCanRead(fileReader, rasterControlPointList);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean canRead(String string) {
        if (string == null) {
            return false;
        }
        Object object = WWIO.getFileOrResourceAsStream(string, this.getClass());
        if (object == null || object instanceof Exception) {
            return false;
        }
        InputStream inputStream = (InputStream)object;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        RasterControlPointList rasterControlPointList = new RasterControlPointList();
        boolean bl = this.doCanRead(inputStreamReader, rasterControlPointList);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            String string2 = Logging.getMessage("generic.ExceptionClosingStream", inputStream);
            Logging.logger().severe(string2);
        }
        return bl;
        catch (Exception exception) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    String string3 = Logging.getMessage("generic.ExceptionClosingStream", inputStream);
                    Logging.logger().severe(string3);
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                String string4 = Logging.getMessage("generic.ExceptionClosingStream", inputStream);
                Logging.logger().severe(string4);
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterControlPointList read(File file) throws IOException {
        RasterControlPointList rasterControlPointList;
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.canRead()) {
            String string = Logging.getMessage("generic.FileNoReadPermission", file);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            RasterControlPointList rasterControlPointList2 = new RasterControlPointList();
            this.doRead(fileReader, rasterControlPointList2);
            rasterControlPointList = rasterControlPointList2;
        }
        catch (Throwable throwable) {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("generic.ExceptionClosingStream", file);
                Logging.logger().severe(string);
            }
            throw throwable;
        }
        try {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.ExceptionClosingStream", file);
            Logging.logger().severe(string);
        }
        return rasterControlPointList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterControlPointList read(String string) throws IOException {
        RasterControlPointList rasterControlPointList;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object object = WWIO.getFileOrResourceAsStream(string, this.getClass());
        if (object == null || object instanceof Exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToReadFile", object != null ? object : string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        InputStream inputStream = (InputStream)object;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            RasterControlPointList rasterControlPointList2 = new RasterControlPointList();
            this.doRead(inputStreamReader, rasterControlPointList2);
            rasterControlPointList = rasterControlPointList2;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                String string4 = Logging.getMessage("generic.ExceptionClosingStream", inputStream);
                Logging.logger().severe(string4);
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            String string5 = Logging.getMessage("generic.ExceptionClosingStream", inputStream);
            Logging.logger().severe(string5);
        }
        return rasterControlPointList;
    }

    protected boolean doCanRead(Reader reader, RasterControlPointList rasterControlPointList) {
        if (reader == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rasterControlPointList == null) {
            String string = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = this.nextLine(bufferedReader);
            Pattern pattern = this.createPattern();
            return pattern.matcher(string).matches();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void doRead(Reader reader, RasterControlPointList rasterControlPointList) throws IOException {
        if (reader == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rasterControlPointList == null) {
            String string = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.readControlPoints(bufferedReader, rasterControlPointList);
    }

    protected void readControlPoints(BufferedReader bufferedReader, RasterControlPointList rasterControlPointList) throws IOException {
        Matcher matcher;
        String string;
        if (bufferedReader == null) {
            String string2 = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (rasterControlPointList == null) {
            String string3 = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Pattern pattern = this.createPattern();
        while ((string = this.nextLine(bufferedReader)) != null && (matcher = pattern.matcher(string)).matches()) {
            String string4 = matcher.group(1);
            String string5 = matcher.group(2);
            String string6 = matcher.group(3);
            String string7 = matcher.group(4);
            Double d = GCPSReader.parseDouble(string4);
            Double d2 = GCPSReader.parseDouble(string5);
            Double d3 = GCPSReader.parseDouble(string6);
            Double d4 = GCPSReader.parseDouble(string7);
            if (d == null || d2 == null || d3 == null || d4 == null) continue;
            RasterControlPointList.ControlPoint controlPoint = new RasterControlPointList.ControlPoint(d, d2, d3, d4);
            rasterControlPointList.add(controlPoint);
        }
    }

    protected Pattern createPattern() {
        String string = this.getDelimiter();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(.+)");
        stringBuilder.append(string).append("+");
        stringBuilder.append("(.+)");
        stringBuilder.append(string).append("+");
        stringBuilder.append("(.+)");
        stringBuilder.append(string).append("+");
        stringBuilder.append("(.+)");
        return Pattern.compile(stringBuilder.toString());
    }

    protected String nextLine(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && string.trim().length() == 0) {
        }
        return string != null ? string.trim() : null;
    }

    private static Double parseDouble(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

