/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import java.nio.ByteBuffer;

public class NITFSFileHeader {
    private String headerID;
    private String version;
    private String specialType;
    private int headerLength;
    private int fileLength;
    private boolean isVersion0210;
    private short complexityLevel;
    private String originationStationId;
    private String dateTime;
    private String title;
    private String FSCLAS;
    private String FSCLSY;
    private String FSCODE;
    private String FSCTLH;
    private String FSREL;
    private String FSDCTP;
    private String FSDCDT;
    private String FSDCXM;
    private String FSDG;
    private String FSDGDT;
    private String FSCLTX;
    private String FSCATP;
    private String FSCAUT;
    private String FSCRSN;
    private String FSSRDT;
    private String FSCTLN;
    private String FSDWNG;
    private String FSDEVT;
    private String FSCOP;
    private String FSCPYS;
    private String ENCRYP;
    private String FBKGC;
    private String ONAME;
    private String OPHONE;

    public NITFSFileHeader(ByteBuffer byteBuffer) {
        this.parseFileHeaderInfo(byteBuffer);
    }

    private void parseFileHeaderInfo(ByteBuffer byteBuffer) {
        this.headerID = NITFSUtil.getString(byteBuffer, 0, 4);
        this.version = NITFSUtil.getString(byteBuffer, 5);
        this.isVersion0210 = "02.10".equals(this.version);
        this.complexityLevel = NITFSUtil.getShortNumeric(byteBuffer, 2);
        this.specialType = NITFSUtil.getString(byteBuffer, 4);
        this.originationStationId = NITFSUtil.getString(byteBuffer, 10);
        this.dateTime = NITFSUtil.getString(byteBuffer, 14);
        this.title = NITFSUtil.getString(byteBuffer, 80);
        this.FSCLAS = NITFSUtil.getString(byteBuffer, 1);
        this.FSCLSY = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 2) : "";
        this.FSCODE = NITFSUtil.getString(byteBuffer, this.isVersion0210 ? 11 : 40);
        this.FSCTLH = NITFSUtil.getString(byteBuffer, this.isVersion0210 ? 2 : 40);
        this.FSREL = NITFSUtil.getString(byteBuffer, this.isVersion0210 ? 20 : 40);
        this.FSDCTP = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 2) : "";
        this.FSDCDT = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 8) : "";
        this.FSDCXM = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 4) : "";
        this.FSDG = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 1) : "";
        this.FSDGDT = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 8) : "";
        this.FSCLTX = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 43) : "";
        this.FSCATP = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 1) : "";
        this.FSCAUT = NITFSUtil.getString(byteBuffer, this.isVersion0210 ? 40 : 20);
        this.FSCRSN = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 1) : "";
        this.FSSRDT = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 8) : "";
        this.FSCTLN = NITFSUtil.getString(byteBuffer, this.isVersion0210 ? 15 : 20);
        this.FSDWNG = this.isVersion0210 ? "" : NITFSUtil.getString(byteBuffer, 6);
        this.FSDEVT = !this.isVersion0210 && "999998".equals(this.FSDWNG) ? NITFSUtil.getString(byteBuffer, 40) : "";
        this.FSCOP = NITFSUtil.getString(byteBuffer, 5);
        this.FSCPYS = NITFSUtil.getString(byteBuffer, 5);
        this.ENCRYP = NITFSUtil.getString(byteBuffer, 1);
        this.FBKGC = this.isVersion0210 ? NITFSUtil.getString(byteBuffer, 297, 3) : "";
        this.ONAME = NITFSUtil.getString(byteBuffer, this.isVersion0210 ? 24 : 27);
        this.OPHONE = NITFSUtil.getString(byteBuffer, 18);
        this.fileLength = NITFSUtil.getNumeric(byteBuffer, 12);
        this.headerLength = NITFSUtil.getNumeric(byteBuffer, 6);
    }

    public String getHeaderID() {
        return this.headerID;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isVersion0210() {
        return this.isVersion0210;
    }

    public short getComplexityLevel() {
        return this.complexityLevel;
    }

    public String getSpecialType() {
        return this.specialType;
    }

    public String getOriginationStationId() {
        return this.originationStationId;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getTitle() {
        return this.title;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public String getFSCLAS() {
        return this.FSCLAS;
    }

    public String getFSCLSY() {
        return this.FSCLSY;
    }

    public String getFSCODE() {
        return this.FSCODE;
    }

    public String getFSCTLH() {
        return this.FSCTLH;
    }

    public String getFSREL() {
        return this.FSREL;
    }

    public String getFSDCTP() {
        return this.FSDCTP;
    }

    public String getFSDCDT() {
        return this.FSDCDT;
    }

    public String getFSDCXM() {
        return this.FSDCXM;
    }

    public String getFSDG() {
        return this.FSDG;
    }

    public String getFSDGDT() {
        return this.FSDGDT;
    }

    public String getFSCLTX() {
        return this.FSCLTX;
    }

    public String getFSCATP() {
        return this.FSCATP;
    }

    public String getFSCAUT() {
        return this.FSCAUT;
    }

    public String getFSCRSN() {
        return this.FSCRSN;
    }

    public String getFSSRDT() {
        return this.FSSRDT;
    }

    public String getFSCTLN() {
        return this.FSCTLN;
    }

    public String getFSDWNG() {
        return this.FSDWNG;
    }

    public String getFSDEVT() {
        return this.FSDEVT;
    }

    public String getFSCOP() {
        return this.FSCOP;
    }

    public String getFSCPYS() {
        return this.FSCPYS;
    }

    public String getENCRYP() {
        return this.ENCRYP;
    }

    public String getFBKGC() {
        return this.FBKGC;
    }

    public String getONAME() {
        return this.ONAME;
    }

    public String getOPHONE() {
        return this.OPHONE;
    }

    public int getFileLength() {
        return this.fileLength;
    }
}

