/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NITFSRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class RPFFrameFileIndexSection {
    private String highestSecurityClassification;
    private long frameFileIndexTableOffset;
    private long numOfFrameFileIndexRecords;
    private int numOfPathnameRecords;
    private int frameFileIndexRecordLength;
    private ArrayList<RPFFrameFileIndexRecord> frameFileIndexTable = new ArrayList();

    public String getHighestSecurityClassification() {
        return this.highestSecurityClassification;
    }

    public long getFrameFileIndexTableOffset() {
        return this.frameFileIndexTableOffset;
    }

    public long getNumOfFrameFileIndexRecords() {
        return this.numOfFrameFileIndexRecords;
    }

    public int getNumOfPathnameRecords() {
        return this.numOfPathnameRecords;
    }

    public int getFrameFileIndexRecordLength() {
        return this.frameFileIndexRecordLength;
    }

    public List<RPFFrameFileIndexRecord> getFrameFileIndexTable() {
        return this.frameFileIndexTable;
    }

    public RPFFrameFileIndexSection(ByteBuffer byteBuffer) {
        this.highestSecurityClassification = NITFSUtil.getString(byteBuffer, 1);
        this.frameFileIndexTableOffset = NITFSUtil.getUInt(byteBuffer);
        this.numOfFrameFileIndexRecords = NITFSUtil.getUInt(byteBuffer);
        this.numOfPathnameRecords = NITFSUtil.getUShort(byteBuffer);
        this.frameFileIndexRecordLength = NITFSUtil.getUShort(byteBuffer);
        this.parseFrameFileIndexAndPathnameTables(byteBuffer);
    }

    private void parseFrameFileIndexAndPathnameTables(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.position();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n3 = 0;
        while ((long)n3 < this.numOfFrameFileIndexRecords) {
            this.frameFileIndexTable.add(new RPFFrameFileIndexRecord(byteBuffer));
            ++n3;
        }
        for (n3 = 0; n3 < this.numOfPathnameRecords; ++n3) {
            int n4 = byteBuffer.position() - n2;
            n = NITFSUtil.getUShort(byteBuffer);
            hashtable.put(n4, NITFSUtil.getString(byteBuffer, n));
        }
        if (0 < this.frameFileIndexTable.size() && 0 < hashtable.size()) {
            for (RPFFrameFileIndexRecord rPFFrameFileIndexRecord : this.frameFileIndexTable) {
                n = (int)rPFFrameFileIndexRecord.getPathnameRecordOffset();
                if (hashtable.containsKey(n)) {
                    rPFFrameFileIndexRecord.setPathname((String)hashtable.get(n));
                    continue;
                }
                throw new NITFSRuntimeException("NITFSReader.CorrespondingPathnameWasNotFound");
            }
        }
    }

    public class RPFFrameFileIndexRecord {
        private int boundaryRectangleRecordNumber;
        private int frameLocationRowNumber;
        private int frameLocationColumnNumber;
        private long pathnameRecordOffset;
        private String frameFileName;
        private String geoLocation;
        private String securityClass;
        private String securityCountryCode;
        private String securityReleaseMark;
        private String pathname;

        public int getBoundaryRectangleRecordNumber() {
            return this.boundaryRectangleRecordNumber;
        }

        public int getFrameLocationRowNumber() {
            return this.frameLocationRowNumber;
        }

        public int getFrameLocationColumnNumber() {
            return this.frameLocationColumnNumber;
        }

        public String getFrameFileName() {
            return this.frameFileName;
        }

        public String getGeoLocation() {
            return this.geoLocation;
        }

        public String getSecurityClass() {
            return this.securityClass;
        }

        public String getSecurityCountryCode() {
            return this.securityCountryCode;
        }

        public String getSecurityReleaseMark() {
            return this.securityReleaseMark;
        }

        public long getPathnameRecordOffset() {
            return this.pathnameRecordOffset;
        }

        public String getPathname() {
            return this.pathname;
        }

        public void setPathname(String string) {
            this.pathname = string;
        }

        public RPFFrameFileIndexRecord(ByteBuffer byteBuffer) {
            this.boundaryRectangleRecordNumber = NITFSUtil.getUShort(byteBuffer);
            this.frameLocationRowNumber = NITFSUtil.getUShort(byteBuffer);
            this.frameLocationColumnNumber = NITFSUtil.getUShort(byteBuffer);
            this.pathnameRecordOffset = NITFSUtil.getUInt(byteBuffer);
            this.frameFileName = NITFSUtil.getString(byteBuffer, 12);
            this.geoLocation = NITFSUtil.getString(byteBuffer, 6);
            this.securityClass = NITFSUtil.getString(byteBuffer, 1);
            this.securityCountryCode = NITFSUtil.getString(byteBuffer, 2);
            this.securityReleaseMark = NITFSUtil.getString(byteBuffer, 2);
            this.pathname = "";
        }
    }
}

