/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.Base34Converter;
import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFFrameFilenameFormatException;
import gov.nasa.worldwind.formats.rpf.RPFProducer;
import gov.nasa.worldwind.formats.rpf.RPFZone;
import gov.nasa.worldwind.util.Logging;

public class RPFFrameFilename {
    private final String dataSeriesCode;
    private final int frameNumber;
    private final char producerId;
    private final int version;
    private final char zoneCode;
    private int hashCode = -1;
    private String filename = null;
    private static final int FILENAME_LENGTH = 12;

    private RPFFrameFilename(String string, int n, char c, int n2, char c2) {
        this.dataSeriesCode = string;
        this.frameNumber = n;
        this.producerId = c;
        this.version = n2;
        this.zoneCode = c2;
    }

    public static RPFFrameFilename parseFilename(String string) {
        int n;
        int n2;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.length() != 12) {
            String string3 = Logging.getMessage("RPFFrameFilename.BadFilenameLength", string);
            Logging.logger().fine(string3);
            throw new RPFFrameFilenameFormatException(string3);
        }
        char[] cArray = new char[12];
        string.getChars(0, 12, cArray, 0);
        char c = cArray[7];
        String string4 = string.substring(9, 11);
        char c2 = cArray[11];
        int n3 = 5;
        int n4 = 2;
        if (RPFDataSeries.isCIBDataSeries(string4)) {
            n3 = 6;
            n4 = 1;
        }
        try {
            n2 = Base34Converter.parseChars(cArray, 0, n3);
            n = Base34Converter.parseChars(cArray, n3, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string5 = Logging.getMessage("RPFFrameFilename.IntegerNotParsed");
            Logging.logger().fine(string5);
            throw new RPFFrameFilenameFormatException(string5, illegalArgumentException);
        }
        return new RPFFrameFilename(string4, n2, c, n, c2);
    }

    private static void toCharArray(RPFFrameFilename rPFFrameFilename, char[] cArray) {
        int n = 5;
        int n2 = 2;
        if (RPFDataSeries.isCIBDataSeries(rPFFrameFilename.dataSeriesCode)) {
            n = 6;
            n2 = 1;
        }
        Base34Converter.valueOf(rPFFrameFilename.frameNumber, cArray, 0, n);
        Base34Converter.valueOf(rPFFrameFilename.version, cArray, n, n2);
        cArray[7] = rPFFrameFilename.producerId;
        cArray[8] = 46;
        rPFFrameFilename.dataSeriesCode.getChars(0, 2, cArray, 9);
        cArray[11] = rPFFrameFilename.zoneCode;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        RPFFrameFilename rPFFrameFilename = (RPFFrameFilename)object;
        if (Character.toUpperCase(this.zoneCode) != Character.toUpperCase(rPFFrameFilename.zoneCode)) {
            return false;
        }
        if (this.frameNumber != rPFFrameFilename.frameNumber) {
            return false;
        }
        if (this.dataSeriesCode != null ? !this.dataSeriesCode.equalsIgnoreCase(rPFFrameFilename.dataSeriesCode) : rPFFrameFilename.dataSeriesCode != null) {
            return false;
        }
        if (Character.toUpperCase(this.producerId) != Character.toUpperCase(rPFFrameFilename.producerId)) {
            return false;
        }
        return this.version == rPFFrameFilename.version;
    }

    public final String getDataSeriesCode() {
        return this.dataSeriesCode;
    }

    public final String getFilename() {
        if (this.filename == null) {
            char[] cArray = new char[12];
            RPFFrameFilename.toCharArray(this, cArray);
            this.filename = new String(cArray);
        }
        return this.filename;
    }

    public final int getFrameNumber() {
        return this.frameNumber;
    }

    public final char getProducerId() {
        return this.producerId;
    }

    public final int getVersion() {
        return this.version;
    }

    public final char getZoneCode() {
        return this.zoneCode;
    }

    public int hashCode() {
        if (this.hashCode < 0) {
            this.hashCode = this.computeHash();
        }
        return this.hashCode;
    }

    private int computeHash() {
        int n = 0;
        if (this.dataSeriesCode != null) {
            n = this.dataSeriesCode.hashCode();
        }
        n = 29 * n + this.frameNumber;
        n = 29 * n + this.producerId;
        n = 29 * n + this.version;
        n = 29 * n + this.zoneCode;
        return n;
    }

    public static boolean isFilename(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.length() != 12) {
            return false;
        }
        char[] cArray = new char[12];
        string.getChars(0, 12, cArray, 0);
        if (!Base34Converter.isBase34(cArray, 0, 7)) {
            return false;
        }
        if (!RPFProducer.isProducerId(Character.valueOf(cArray[7]))) {
            return false;
        }
        if ('.' != cArray[8]) {
            return false;
        }
        String string3 = string.substring(9, 11);
        if (!RPFDataSeries.isDataSeriesCode(string3)) {
            return false;
        }
        return RPFZone.isZoneCode(cArray[11]);
    }

    public final String toString() {
        return this.getFilename();
    }
}

