/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFFrameStructure;
import gov.nasa.worldwind.formats.rpf.RPFZone;
import gov.nasa.worldwind.util.Logging;

class RPFPolarFrameStructure
extends RPFFrameStructure {
    private final int polarPixelConstant;
    private final double polewardExtent;
    private final double equatorwardExtent;
    private final int polarFrames;

    private RPFPolarFrameStructure(int n, double d, double d2, int n2) {
        this.polarPixelConstant = n;
        this.polewardExtent = d;
        this.equatorwardExtent = d2;
        this.polarFrames = n2;
    }

    public static RPFPolarFrameStructure computeStructure(char c, String string, double d) {
        int n;
        int n2;
        if (!RPFZone.isZoneCode(c)) {
            String string2 = Logging.getMessage("RPFZone.UnknownZoneCode", Character.valueOf(c));
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null || !RPFDataSeries.isRPFDataType(string)) {
            String string3 = Logging.getMessage("RPFDataSeries.UnkownDataType", string);
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        if (d < 0.0) {
            String string4 = Logging.getMessage("generic.ArgumentOutOfRange", string);
            Logging.logger().fine(string4);
            throw new IllegalArgumentException(string4);
        }
        int n3 = RPFPolarFrameStructure.northSouthPixelSpacingConstant();
        if (RPFDataSeries.isCADRGDataType(string)) {
            n2 = RPFPolarFrameStructure.polarPixelConstant_CADRG(n3, d);
            n = RPFPolarFrameStructure.polarFrames_CADRG(n2);
        } else if (RPFDataSeries.isCIBDataType(string)) {
            int n4 = RPFPolarFrameStructure.northSouthPixelConstant_CIB(n3, d);
            n2 = RPFPolarFrameStructure.polarPixelConstant_CIB(n4);
            n = RPFPolarFrameStructure.polarFrames_CIB(n2);
        } else {
            n2 = -1;
            n = -1;
        }
        double d2 = RPFPolarFrameStructure.polewardExtent(RPFPolarFrameStructure.polewardNominalBoundary(c));
        double d3 = RPFPolarFrameStructure.equatorwardExtent(RPFPolarFrameStructure.equatorwardNominalBoundary(c));
        return new RPFPolarFrameStructure(n2, d2, d3, n);
    }

    public final int getPolarPixelConstant() {
        return this.polarPixelConstant;
    }

    public final double getPolewardExtent() {
        return this.polewardExtent;
    }

    public final double getEquatorwardExtent() {
        return this.equatorwardExtent;
    }

    public final int getPolarFrames() {
        return this.polarFrames;
    }

    private static int northSouthPixelConstant_CIB(double d, double d2) {
        double d3 = 100.0 / d2;
        double d4 = d * d3;
        d4 = 512.0 * (double)((int)Math.ceil(d4 / 512.0));
        return 256 * (int)Math.round((d4 /= 4.0) / 256.0);
    }

    private static int polarPixelConstant_CADRG(double d, double d2) {
        double d3 = 1000000.0 / d2;
        double d4 = d * d3;
        d4 = 512.0 * (double)((int)Math.ceil(d4 / 512.0));
        d4 *= 0.05555555555555555;
        d4 /= 1.5;
        d4 = 512.0 * (double)((int)Math.round(d4 / 512.0));
        return (int)(d4 * 360.0 / 20.0);
    }

    private static int polarPixelConstant_CIB(double d) {
        double d2 = d * 20.0 / 90.0;
        d2 = 512.0 * (double)((int)Math.round(d2 / 512.0));
        return (int)(d2 * 90.0 / 20.0);
    }

    private static int polarFrames_CADRG(double d) {
        double d2 = d * 20.0 / 360.0;
        d2 /= 256.0;
        d2 /= 6.0;
        if ((int)(d2 = Math.ceil(d2)) % 2 == 0) {
            d2 += 1.0;
        }
        return (int)d2;
    }

    private static int polarFrames_CIB(double d) {
        double d2 = d * 20.0 / 90.0;
        d2 /= 256.0;
        d2 += 4.0;
        d2 /= 6.0;
        if ((int)(d2 = Math.ceil(d2)) % 2 == 0) {
            d2 += 1.0;
        }
        return (int)d2;
    }

    private static double polewardExtent(double d) {
        return d;
    }

    private static double equatorwardExtent(double d) {
        return d;
    }
}

