/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tab;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RasterControlPointList;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TABRasterReader {
    public static final String VERSION = "TABRaster.Version";
    public static final String CHARSET = "TABRaster.Charset";
    public static final String TYPE = "TABRaster.Type";
    public static final String IMAGE_PATH = "TABRaster.ImagePath";
    public static final String LABEL = "TABRaster.Label";
    public static final String RASTER_STYLE_BRIGHTNESS_VALUE = "TABRaster.RasterStyleBrightnessValue";
    public static final String RASTER_STYLE_CONTRAST_VALUE = "TABRaster.RasterStyleContrastValue";
    public static final String RASTER_STYLE_GRAYSCALE_VALUE = "TABRaster.RasterStyleGrayscaleValue";
    public static final String RASTER_STYLE_USE_TRANSPARENT_VALUE = "TABRaster.RasterStyleUseTransparentValue";
    public static final String RASTER_STYLE_TRANSPARENT_INDEX_VALUE = "TABRaster.RasterStyleTransparentIndexValue";
    public static final String RASTER_STYLE_GRID_VALUE = "TABRaster.RasterStyleGridValue";
    public static final String RASTER_STYLE_TRANSPARENT_COLOR_VALUE = "TABRaster.TransparentColorValue";
    public static final String RASTER_STYLE_TRANSLUCENT_ALPHA_VALUE = "TABRaster.TranslucentAlphaValue";
    protected static final String TAG_DEFINITION = "Definition";
    protected static final String TAG_FILE = "File";
    protected static final String TAG_HEADER_TABLE = "!table";
    protected static final String TAG_HEADER_VERSION = "!version";
    protected static final String TAG_HEADER_CHARSET = "!charset";
    protected static final String TAG_TABLE = "Table";
    protected static final String TAG_TYPE = "Type";
    protected static final int RASTER_STYLE_ID_BRIGHTNESS_VALUE = 1;
    protected static final int RASTER_STYLE_ID_CONTRAST_VALUE = 2;
    protected static final int RASTER_STYLE_ID_GRAYSCALE_VALUE = 3;
    protected static final int RASTER_STYLE_ID_USE_TRANSPARENT_VALUE = 4;
    protected static final int RASTER_STYLE_ID_TRANSPARENT_INDEX_VALUE = 5;
    protected static final int RASTER_STYLE_ID_GRID_VALUE = 6;
    protected static final int RASTER_STYLE_ID_TRANSPARENT_COLOR_VALUE = 7;
    protected static final int RASTER_STYLE_ID_TRANSLUCENT_ALPHA_VALUE = 8;

    public static File getTABFileFor(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return null;
        }
        String string = WWIO.replaceSuffix(file.getName(), ".tab");
        if (file.getName().equalsIgnoreCase(string)) {
            return null;
        }
        for (File file3 : file2.listFiles()) {
            if (file3.equals(file) || !file3.getName().equalsIgnoreCase(string)) continue;
            return file3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            return false;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            RasterControlPointList rasterControlPointList = new RasterControlPointList();
            boolean bl = this.doCanRead(fileReader, rasterControlPointList);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(String string) {
        if (string == null) {
            return false;
        }
        Object object = WWIO.getFileOrResourceAsStream(string, this.getClass());
        if (object == null || object instanceof Exception) {
            return false;
        }
        InputStream inputStream = (InputStream)object;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            RasterControlPointList rasterControlPointList = new RasterControlPointList();
            boolean bl = this.doCanRead(inputStreamReader, rasterControlPointList);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            WWIO.closeStream(inputStream, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterControlPointList read(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.canRead()) {
            String string = Logging.getMessage("generic.FileNoReadPermission", file);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            RasterControlPointList rasterControlPointList = new RasterControlPointList();
            this.doRead(fileReader, file.getParent(), rasterControlPointList);
            RasterControlPointList rasterControlPointList2 = rasterControlPointList;
            return rasterControlPointList2;
        }
        finally {
            WWIO.closeStream(fileReader, file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterControlPointList read(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object object = WWIO.getFileOrResourceAsStream(string, this.getClass());
        if (object == null || object instanceof Exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToReadFile", object != null ? object : string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        InputStream inputStream = (InputStream)object;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            String string4 = WWIO.getParentFilePath(string);
            RasterControlPointList rasterControlPointList = new RasterControlPointList();
            this.doRead(inputStreamReader, string4, rasterControlPointList);
            RasterControlPointList rasterControlPointList2 = rasterControlPointList;
            return rasterControlPointList2;
        }
        finally {
            WWIO.closeStream(inputStream, string);
        }
    }

    protected boolean doCanRead(Reader reader, RasterControlPointList rasterControlPointList) {
        if (reader == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rasterControlPointList == null) {
            String string = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            this.readHeader(bufferedReader, rasterControlPointList);
            String string = this.validateHeaderValues(rasterControlPointList);
            return string == null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void doRead(Reader reader, String string, RasterControlPointList rasterControlPointList) throws IOException {
        if (reader == null) {
            String string2 = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (rasterControlPointList == null) {
            String string3 = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.readHeader(bufferedReader, rasterControlPointList);
        this.readDefinitionTable(bufferedReader, string, rasterControlPointList);
        String string4 = this.validateHeaderValues(rasterControlPointList);
        if (string4 != null) {
            String string5 = Logging.getMessage("TABReader.MissingHeaderValues", string4);
            Logging.logger().severe(string5);
            throw new IOException(string5);
        }
        string4 = this.validateRasterControlPoints(rasterControlPointList);
        if (string4 != null) {
            String string6 = Logging.getMessage("TABReader.MissingRasterData", string4);
            Logging.logger().severe(string6);
            throw new IOException(string6);
        }
    }

    protected void readHeader(BufferedReader bufferedReader, RasterControlPointList rasterControlPointList) throws IOException {
        if (bufferedReader == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rasterControlPointList == null) {
            String string = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.skipToHeader(bufferedReader);
        if (string == null || !string.equalsIgnoreCase(TAG_HEADER_TABLE)) {
            String string2 = Logging.getMessage("TABReader.InvalidMagicString", string);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        string = this.nextLine(bufferedReader);
        if (string != null && string.startsWith(TAG_HEADER_VERSION) && rasterControlPointList.getValue(VERSION) == null) {
            TABRasterReader.setProperty(string, VERSION, rasterControlPointList);
        }
        if ((string = this.nextLine(bufferedReader)) != null && string.startsWith(TAG_HEADER_CHARSET) && rasterControlPointList.getValue(CHARSET) == null) {
            TABRasterReader.setProperty(string, CHARSET, rasterControlPointList);
        }
    }

    protected void readDefinitionTable(BufferedReader bufferedReader, String string, RasterControlPointList rasterControlPointList) throws IOException {
        String[] stringArray;
        if (bufferedReader == null) {
            String string2 = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (rasterControlPointList == null) {
            String string3 = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = this.skipToDefinition(bufferedReader);
        if (string4 == null || !string4.equalsIgnoreCase(TAG_TABLE)) {
            return;
        }
        string4 = this.nextLine(bufferedReader);
        if (string4 != null && string4.startsWith(TAG_FILE) && (rasterControlPointList.getStringValue(IMAGE_PATH) == null || rasterControlPointList.getStringValue(IMAGE_PATH).length() == 0) && (stringArray = string4.split(" ", 2)).length >= 2 && stringArray[1] != null) {
            String string5 = TABRasterReader.stripQuotes(stringArray[1].trim());
            rasterControlPointList.setValue(IMAGE_PATH, WWIO.appendPathPart(string, string5));
        }
        if ((string4 = this.nextLine(bufferedReader)) != null && string4.startsWith(TAG_TYPE) && rasterControlPointList.getValue(TYPE) == null) {
            TABRasterReader.setProperty(string4, TYPE, rasterControlPointList);
        }
        this.readControlPoints(bufferedReader, rasterControlPointList);
        this.readCoordSys(bufferedReader, rasterControlPointList);
        this.readRasterStyle(bufferedReader, rasterControlPointList);
    }

    protected void readControlPoints(BufferedReader bufferedReader, RasterControlPointList rasterControlPointList) throws IOException {
        Matcher matcher;
        String string;
        if (bufferedReader == null) {
            String string2 = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (rasterControlPointList == null) {
            String string3 = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Pattern pattern = Pattern.compile("[(](.+)[,](.+)[)].+[(](.+)[,](.+)[)][\\s]+.+[\\s]+[\"']?(.+)[\"']?[,]?");
        while ((string = this.nextLine(bufferedReader)) != null && (matcher = pattern.matcher(string)).matches()) {
            String string4 = matcher.group(1);
            String string5 = matcher.group(2);
            String string6 = matcher.group(3);
            String string7 = matcher.group(4);
            String string8 = matcher.group(5);
            Double d = WWUtil.convertStringToDouble(string4);
            Double d2 = WWUtil.convertStringToDouble(string5);
            Double d3 = WWUtil.convertStringToDouble(string6);
            Double d4 = WWUtil.convertStringToDouble(string7);
            if (d == null || d2 == null || d3 == null || d4 == null) continue;
            RasterControlPointList.ControlPoint controlPoint = new RasterControlPointList.ControlPoint(d, d2, d3, d4);
            controlPoint.setValue(LABEL, string8);
            rasterControlPointList.add(controlPoint);
        }
    }

    protected void readCoordSys(BufferedReader bufferedReader, RasterControlPointList rasterControlPointList) throws IOException {
        if (bufferedReader == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rasterControlPointList == null) {
            String string = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    protected void readRasterStyle(BufferedReader bufferedReader, RasterControlPointList rasterControlPointList) throws IOException {
        if (rasterControlPointList == null) {
            String string = Logging.getMessage("nullValue.RasterControlPointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    protected String skipToHeader(BufferedReader bufferedReader) throws IOException {
        return this.nextLine(bufferedReader);
    }

    protected String skipToDefinition(BufferedReader bufferedReader) throws IOException {
        String string = this.nextLine(bufferedReader);
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split(" ", 2);
        if (stringArray.length < 2) {
            return null;
        }
        return stringArray[1] != null ? stringArray[1].trim() : null;
    }

    protected String nextLine(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && string.trim().length() == 0) {
        }
        return string != null ? string.trim() : null;
    }

    protected String validateHeaderValues(AVList aVList) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = aVList.getStringValue(VERSION);
        if (string == null || string.length() == 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Logging.getMessage("term.version"));
        }
        if ((string = aVList.getStringValue(CHARSET)) == null || string.length() == 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Logging.getMessage("term.charset"));
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    protected String validateRasterControlPoints(RasterControlPointList rasterControlPointList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (rasterControlPointList.getStringValue(IMAGE_PATH) == null && rasterControlPointList.getStringValue(IMAGE_PATH).length() == 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Logging.getMessage("TABReader.MissingOrInvalidFileName", rasterControlPointList.getStringValue(IMAGE_PATH)));
        }
        if (rasterControlPointList.size() < 3) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Logging.getMessage("TABReader.NotEnoughControlPoints", rasterControlPointList.size()));
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    private static String stripQuotes(String string) {
        if (string.startsWith("\"") || string.startsWith("'")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("\"") || string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static void setProperty(String string, String string2, AVList aVList) {
        String[] stringArray = string.split(" ", 2);
        if (stringArray == null || stringArray.length < 2) {
            return;
        }
        String string3 = stringArray[1];
        if (string3 == null || string3.trim().length() == 0) {
            return;
        }
        aVList.setValue(string2, string3.trim());
    }
}

