/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.vpf.VPFSymbolAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class GeoSymStyleProvider {
    private static String TYPE_LINE_PLAIN = "LinePlain";
    private static String TYPE_LINE_COMPLEX = "LineComplex";
    private static String TYPE_AREA_PLAIN = "AreaPlain";
    private static String TYPE_AREA_PATTERN = "AreaPattern";
    private static final int CODE = 0;
    private static final int TYPE = 1;
    private static final int LINE_WIDTH = 2;
    private static final int LINE_COLOR = 3;
    private static final int STIPPLE_PATTERN = 4;
    private static final int STIPPLE_FACTOR = 5;
    private static final int FILL_COLOR = 6;
    private Map<String, VPFSymbolAttributes> attributes;
    private double lineWidthFactor = 3.0;

    public GeoSymStyleProvider(String string) {
        try {
            this.loadStylesFromFile(string);
        }
        catch (IOException iOException) {
            String string2 = Logging.getMessage("generic.ExceptionWhileReading", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
    }

    protected void loadStylesFromFile(String string) throws IOException {
        InputStream inputStream = WWIO.openFileOrResourceStream(string, this.getClass());
        if (inputStream == null) {
            String string2 = Logging.getMessage("generic.ExceptionWhileReading", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        this.attributes = new HashMap<String, VPFSymbolAttributes>();
        Scanner scanner = new Scanner(inputStream);
        while (scanner.hasNextLine()) {
            String string3 = scanner.nextLine().trim();
            if (string3.length() == 0 || string3.startsWith("#")) continue;
            String[] stringArray = string3.split(",");
            String string4 = stringArray[0];
            VPFSymbolAttributes vPFSymbolAttributes = this.getAttributes(stringArray);
            if (vPFSymbolAttributes == null) continue;
            this.attributes.put(string4, vPFSymbolAttributes);
        }
        inputStream.close();
    }

    private VPFSymbolAttributes getAttributes(String[] stringArray) {
        VPFSymbolAttributes vPFSymbolAttributes = new VPFSymbolAttributes(null, null);
        if (stringArray[1].equals(TYPE_AREA_PLAIN) || stringArray[1].equals(TYPE_AREA_PATTERN)) {
            vPFSymbolAttributes.setInteriorMaterial(new Material(Color.decode(stringArray[6])));
            if (stringArray[1].equals(TYPE_AREA_PATTERN)) {
                vPFSymbolAttributes.setImageSource(stringArray[0]);
            }
        } else if (stringArray[1].equals(TYPE_LINE_PLAIN) || stringArray[1].equals(TYPE_LINE_COMPLEX)) {
            vPFSymbolAttributes.setOutlineMaterial(new Material(Color.decode(stringArray[3])));
            vPFSymbolAttributes.setOutlineWidth(Double.parseDouble(stringArray[2]) * this.lineWidthFactor);
            if (stringArray[1].equals(TYPE_LINE_COMPLEX)) {
                vPFSymbolAttributes.setOutlineStipplePattern(Integer.decode(stringArray[4]).shortValue());
                vPFSymbolAttributes.setOutlineStippleFactor(Integer.parseInt(stringArray[5]));
            }
        }
        return vPFSymbolAttributes;
    }

    public VPFSymbolAttributes getAttributes(String string) {
        return this.attributes.get(string);
    }
}

