/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.formats.vpf.VPFCoverage;
import gov.nasa.worldwind.formats.vpf.VPFDatabase;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFLayer;
import gov.nasa.worldwind.formats.vpf.VPFLegendSupport;
import gov.nasa.worldwind.formats.vpf.VPFLibrary;
import gov.nasa.worldwind.formats.vpf.VPFSymbol;
import gov.nasa.worldwind.formats.vpf.VPFSymbolAttributes;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class VPFCoveragePanel
extends JPanel {
    private WorldWindow wwd;
    private Dimension preferredSize;
    private JTabbedPane libraryTabbedPane;
    private VPFLayer layer;
    private JPanel legendPanel;

    public VPFCoveragePanel(WorldWindow worldWindow, VPFDatabase vPFDatabase) {
        super(new BorderLayout());
        this.wwd = worldWindow;
        this.makePanel(vPFDatabase, new Dimension(200, 400));
    }

    public VPFCoveragePanel(VPFDatabase vPFDatabase, Dimension dimension) {
        super(new BorderLayout());
        this.makePanel(vPFDatabase, dimension);
    }

    public VPFLayer getLayer() {
        return this.layer;
    }

    public void setLayer(VPFLayer vPFLayer) {
        this.layer = vPFLayer;
        this.fillLegendPanel();
    }

    private void makePanel(VPFDatabase vPFDatabase, Dimension dimension) {
        this.preferredSize = dimension;
        this.libraryTabbedPane = new JTabbedPane();
        this.add((Component)this.libraryTabbedPane, "Center");
        this.fill(vPFDatabase);
        this.startLegendUpdateTimer();
    }

    private void fill(VPFDatabase vPFDatabase) {
        this.addDatabase(vPFDatabase);
        this.addLegend();
    }

    public void addDatabase(VPFDatabase vPFDatabase) {
        ArrayList<VPFLibrary> arrayList = new ArrayList<VPFLibrary>();
        arrayList.addAll(vPFDatabase.getLibraries());
        this.sortPropertyLists(arrayList, "gov.nasa.worldwind.avkey.DisplayName");
        for (VPFLibrary vPFLibrary : arrayList) {
            this.addLibrary(vPFDatabase, vPFLibrary);
        }
    }

    public void addLibrary(VPFDatabase vPFDatabase, VPFLibrary vPFLibrary) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (this.preferredSize != null) {
            jScrollPane.setPreferredSize(this.preferredSize);
        }
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel3.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Coverage")));
        jPanel3.setToolTipText("Coverage to Show");
        jPanel3.add(jScrollPane);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(18, 9, 0, 9));
        ZoomAction zoomAction = new ZoomAction(vPFLibrary);
        JButton jButton = new JButton(zoomAction);
        jButton.setAlignmentX(0.0f);
        box.add(jButton);
        box.add(Box.createVerticalStrut(18));
        LibraryAction libraryAction = new LibraryAction(vPFDatabase, vPFLibrary, false);
        JCheckBox jCheckBox = new JCheckBox(libraryAction);
        jCheckBox.setSelected(libraryAction.selected);
        jCheckBox.setAlignmentX(0.0f);
        box.add(jCheckBox);
        jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)box, "North");
        jPanel2.add((Component)jPanel3, "Center");
        this.libraryTabbedPane.add(vPFLibrary.getName(), jPanel2);
        int n = this.libraryTabbedPane.indexOfComponent(jPanel2);
        this.libraryTabbedPane.setToolTipTextAt(n, vPFLibrary.getDescription());
        ArrayList<VPFCoverage> arrayList = new ArrayList<VPFCoverage>();
        arrayList.addAll(vPFLibrary.getCoverages());
        this.sortPropertyLists(arrayList, "gov.nasa.worldwind.avkey.Description");
        for (VPFCoverage vPFCoverage : arrayList) {
            if (vPFCoverage.isReferenceCoverage()) continue;
            this.addCoverage(vPFDatabase, vPFCoverage, jPanel);
        }
    }

    protected void sortPropertyLists(List<? extends AVList> list, final String string) {
        Collections.sort(list, new Comparator<AVList>(){

            @Override
            public int compare(AVList aVList, AVList aVList2) {
                String string3 = aVList.getValue(string) != null ? aVList.getValue(string).toString() : "";
                String string2 = aVList2.getValue(string) != null ? aVList2.getValue(string).toString() : "";
                return String.CASE_INSENSITIVE_ORDER.compare(string3, string2);
            }
        });
    }

    public void addLegend() {
        this.legendPanel = new JPanel();
        this.legendPanel.setLayout(new BoxLayout(this.legendPanel, 3));
        this.legendPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.legendPanel, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (this.preferredSize != null) {
            jScrollPane.setPreferredSize(this.preferredSize);
        }
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel2.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Legend")));
        jPanel2.setToolTipText("VPF Layer Legend");
        jPanel2.add(jScrollPane);
        jPanel2.setAlignmentX(0.0f);
        Box box = Box.createVerticalBox();
        box.add(jPanel2);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)box, "Center");
        this.libraryTabbedPane.add("Legend", jPanel);
    }

    protected void fillLegendPanel() {
        this.legendPanel.removeAll();
        if (this.layer == null) {
            return;
        }
        Iterable<VPFSymbol> iterable = this.layer.getActiveSymbols();
        if (iterable == null) {
            return;
        }
        Iterable<SymbolInfo> iterable2 = this.getUniqueSymbols(iterable);
        VPFLegendSupport vPFLegendSupport = new VPFLegendSupport();
        String string = null;
        for (SymbolInfo symbolInfo : iterable2) {
            BufferedImage bufferedImage;
            Object object;
            if (string == null || !symbolInfo.getFeatureClass().getCoverage().getName().equals(string)) {
                if (string != null) {
                    this.legendPanel.add(Box.createVerticalStrut(5));
                }
                object = new JLabel(symbolInfo.getFeatureClass().getCoverage().getDescription());
                this.legendPanel.add((Component)object);
                string = symbolInfo.getFeatureClass().getCoverage().getName();
                this.legendPanel.add(new JSeparator(0));
                this.legendPanel.add(Box.createVerticalStrut(5));
            }
            Object object2 = object = symbolInfo.getDescription() != null ? symbolInfo.getDescription() : "";
            if (((String)object).length() > 0) {
                object = ((String)object).substring(0, 1).toUpperCase() + ((String)object).substring(1);
            }
            if ((bufferedImage = vPFLegendSupport.createLegendImage(symbolInfo.getAttributes(), 60, 22, 0)) == null || ((String)object).length() <= 0) continue;
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            JLabel jLabel = new JLabel((String)object, imageIcon, 2);
            jLabel.setIconTextGap(8);
            this.legendPanel.add(jLabel);
            this.legendPanel.add(Box.createVerticalStrut(2));
        }
        this.legendPanel.revalidate();
        this.legendPanel.repaint();
    }

    protected Iterable<SymbolInfo> getUniqueSymbols(Iterable<VPFSymbol> iterable) {
        TreeSet<SymbolInfo> treeSet = new TreeSet<SymbolInfo>(new Comparator<SymbolInfo>(){

            @Override
            public int compare(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) {
                int n;
                String string;
                String string2;
                String string3 = symbolInfo.getFeatureClass().getCoverage().getName() != null ? symbolInfo.getFeatureClass().getCoverage().getName() : "";
                int n2 = String.CASE_INSENSITIVE_ORDER.compare(string3, string2 = symbolInfo2.getFeatureClass().getCoverage().getName() != null ? symbolInfo2.getFeatureClass().getCoverage().getName() : "");
                if (n2 != 0) {
                    return n2;
                }
                String string4 = symbolInfo.getAttributes().getSymbolKey() != null ? symbolInfo.getAttributes().getSymbolKey().toString() : "";
                n2 = String.CASE_INSENSITIVE_ORDER.compare(string4, string = symbolInfo2.getAttributes().getSymbolKey() != null ? symbolInfo2.getAttributes().getSymbolKey().toString() : "");
                if (n2 != 0) {
                    return n2;
                }
                int n3 = symbolInfo.getFeatureClass().getType() != null ? symbolInfo.getFeatureClass().getType().ordinal() : -1;
                int n4 = n = symbolInfo2.getFeatureClass().getType() != null ? symbolInfo2.getFeatureClass().getType().ordinal() : -1;
                return n3 < n ? -1 : (n3 > n ? 1 : 0);
            }
        });
        for (VPFSymbol vPFSymbol : iterable) {
            if (vPFSymbol == null || vPFSymbol.getFeature() == null || vPFSymbol.getAttributes() == null) continue;
            treeSet.add(new SymbolInfo(vPFSymbol.getFeature().getFeatureClass(), vPFSymbol.getAttributes()));
        }
        return treeSet;
    }

    protected void addCoverage(VPFDatabase vPFDatabase, VPFCoverage vPFCoverage, Container container) {
        CoverageAction coverageAction = new CoverageAction(vPFDatabase, vPFCoverage, false);
        JCheckBox jCheckBox = new JCheckBox(coverageAction);
        jCheckBox.setSelected(coverageAction.selected);
        container.add(jCheckBox);
    }

    public void update(VPFDatabase vPFDatabase) {
        this.libraryTabbedPane.removeAll();
        this.fill(vPFDatabase);
        this.libraryTabbedPane.revalidate();
        this.libraryTabbedPane.repaint();
    }

    public void clear() {
        this.libraryTabbedPane.removeAll();
        this.libraryTabbedPane.revalidate();
        this.libraryTabbedPane.repaint();
    }

    private void startLegendUpdateTimer() {
        Timer timer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VPFCoveragePanel.this.fillLegendPanel();
            }
        });
        timer.start();
    }

    private class ZoomAction
    extends AbstractAction {
        private VPFLibrary library;

        private ZoomAction(VPFLibrary vPFLibrary) {
            super("Zoom To Library");
            this.library = vPFLibrary;
            this.setEnabled(this.library.getBounds() != null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Sector sector = this.library.getBounds().toSector();
            Cylinder cylinder = Sector.computeBoundingCylinder(VPFCoveragePanel.this.wwd.getModel().getGlobe(), VPFCoveragePanel.this.wwd.getSceneController().getVerticalExaggeration(), sector);
            Angle angle = VPFCoveragePanel.this.wwd.getView().getFieldOfView();
            Position position = new Position(sector.getCentroid(), 0.0);
            double d = cylinder.getRadius() / angle.cosHalfAngle() / angle.tanHalfAngle();
            VPFCoveragePanel.this.wwd.getView().goTo(position, d);
        }
    }

    private class CoverageAction
    extends AbstractAction
    implements PropertyChangeListener {
        VPFDatabase db;
        VPFCoverage coverage;
        private boolean selected;

        public CoverageAction(VPFDatabase vPFDatabase, VPFCoverage vPFCoverage, boolean bl) {
            super(vPFCoverage.getDescription());
            this.putValue("ShortDescription", "Show " + vPFCoverage.getDescription());
            this.db = vPFDatabase;
            this.coverage = vPFCoverage;
            this.selected = bl;
            this.db.addPropertyChangeListener(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            this.db.firePropertyChange(new PropertyChangeEvent(this.coverage, "VPFLayer.CoverageChanged", this.selected, bl));
            this.selected = bl;
            VPFCoveragePanel.this.wwd.redraw();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("VPFLayer.LibraryChanged")) {
                VPFLibrary vPFLibrary = (VPFLibrary)propertyChangeEvent.getSource();
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (vPFLibrary.getFilePath().equals(this.coverage.getLibrary().getFilePath())) {
                    this.setEnabled(bl);
                }
            }
        }
    }

    private class LibraryAction
    extends AbstractAction {
        VPFDatabase db;
        VPFLibrary library;
        private boolean selected;

        public LibraryAction(VPFDatabase vPFDatabase, VPFLibrary vPFLibrary, boolean bl) {
            super("Show Library");
            this.putValue("ShortDescription", "Show " + vPFLibrary.getName());
            this.db = vPFDatabase;
            this.library = vPFLibrary;
            this.selected = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            this.db.firePropertyChange(new PropertyChangeEvent(this.library, "VPFLayer.LibraryChanged", this.selected, bl));
            this.selected = bl;
            VPFCoveragePanel.this.wwd.redraw();
        }
    }

    protected static class SymbolInfo {
        protected VPFFeatureClass featureClass;
        protected VPFSymbolAttributes attributes;

        public SymbolInfo(VPFFeatureClass vPFFeatureClass, VPFSymbolAttributes vPFSymbolAttributes) {
            this.featureClass = vPFFeatureClass;
            this.attributes = vPFSymbolAttributes;
        }

        public VPFFeatureClass getFeatureClass() {
            return this.featureClass;
        }

        public VPFSymbolAttributes getAttributes() {
            return this.attributes;
        }

        public String getDescription() {
            return this.attributes.getDescription();
        }
    }
}

