/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.vpf.VPFCoverage;
import gov.nasa.worldwind.formats.vpf.VPFFeature;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClassSchema;
import gov.nasa.worldwind.formats.vpf.VPFFeatureFactory;
import gov.nasa.worldwind.formats.vpf.VPFFeatureType;
import gov.nasa.worldwind.formats.vpf.VPFRelation;
import gov.nasa.worldwind.formats.vpf.VPFSymbol;
import gov.nasa.worldwind.formats.vpf.VPFSymbolFactory;
import java.util.Arrays;
import java.util.Collection;

public class VPFFeatureClass
extends AVListImpl {
    protected VPFCoverage coverage;
    protected VPFFeatureClassSchema schema;
    protected VPFRelation[] relations;
    protected String joinTableName;
    protected String primitiveTableName;

    public VPFFeatureClass(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema, String string, String string2) {
        this.coverage = vPFCoverage;
        this.schema = vPFFeatureClassSchema;
        this.joinTableName = string;
        this.primitiveTableName = string2;
    }

    public VPFCoverage getCoverage() {
        return this.coverage;
    }

    public VPFFeatureClassSchema getSchema() {
        return this.schema;
    }

    public String getClassName() {
        return this.schema.getClassName();
    }

    public VPFFeatureType getType() {
        return this.schema.getType();
    }

    public String getFeatureTableName() {
        return this.schema.getFeatureTableName();
    }

    public String getJoinTableName() {
        return this.joinTableName;
    }

    public String getPrimitiveTableName() {
        return this.primitiveTableName;
    }

    public VPFRelation[] getRelations() {
        return this.relations;
    }

    public void setRelations(VPFRelation[] vPFRelationArray) {
        this.relations = vPFRelationArray;
    }

    public Collection<? extends VPFFeature> createFeatures(VPFFeatureFactory vPFFeatureFactory) {
        return null;
    }

    public Collection<? extends VPFSymbol> createFeatureSymbols(VPFSymbolFactory vPFSymbolFactory) {
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VPFFeatureClass vPFFeatureClass = (VPFFeatureClass)object;
        if (this.coverage != null ? !this.coverage.getFilePath().equals(vPFFeatureClass.coverage.getFilePath()) : vPFFeatureClass.coverage != null) {
            return false;
        }
        if (this.schema != null ? !this.schema.equals(vPFFeatureClass.schema) : vPFFeatureClass.schema != null) {
            return false;
        }
        if (!Arrays.equals(this.relations, vPFFeatureClass.relations)) {
            return false;
        }
        if (this.joinTableName != null ? !this.joinTableName.equals(vPFFeatureClass.joinTableName) : vPFFeatureClass.joinTableName != null) {
            return false;
        }
        return !(this.primitiveTableName != null ? !this.primitiveTableName.equals(vPFFeatureClass.primitiveTableName) : vPFFeatureClass.primitiveTableName != null);
    }

    public int hashCode() {
        int n = this.coverage != null ? this.coverage.hashCode() : 0;
        n = 31 * n + (this.schema != null ? this.schema.hashCode() : 0);
        n = 31 * n + (this.relations != null ? Arrays.hashCode(this.relations) : 0);
        n = 31 * n + (this.joinTableName != null ? this.joinTableName.hashCode() : 0);
        n = 31 * n + (this.primitiveTableName != null ? this.primitiveTableName.hashCode() : 0);
        return n;
    }
}

