/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class StarsConvertor {
    private static final float DEFAULT_RADIUS = 6.356752E7f;

    public static void convertTsvToDat(String string) {
        String string2 = WWIO.replaceSuffix(string, ".dat");
        StarsConvertor.convertTsvToDat(string, string2, 6.356752E7f);
    }

    public static void convertTsvToDat(String string, float f) {
        String string2 = WWIO.replaceSuffix(string, ".dat");
        StarsConvertor.convertTsvToDat(string, string2, f);
    }

    public static void convertTsvToDat(String string, String string2) {
        StarsConvertor.convertTsvToDat(string, string2, 6.356752E7f);
    }

    public static void convertTsvToDat(String string, String string2, float f) {
        ByteBuffer byteBuffer = StarsConvertor.convertTsvToByteBuffer(string, f);
        try {
            WWIO.saveBuffer(byteBuffer, new File(string2));
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionAttemptingToWriteTo", string2), iOException);
        }
    }

    public static ByteBuffer convertTsvToByteBuffer(String string) {
        return StarsConvertor.convertTsvToByteBuffer(string, 6.356752E7f);
    }

    public static ByteBuffer convertTsvToByteBuffer(String string, float f) {
        try {
            Object object;
            String[] stringArray;
            String string2;
            Object object2;
            ArrayList<Float> arrayList = new ArrayList<Float>();
            InputStream inputStream = StarsConvertor.class.getResourceAsStream("/" + string);
            if (inputStream == null && ((File)(object2 = new File(string))).exists()) {
                inputStream = new FileInputStream((File)object2);
            }
            if (inputStream == null) {
                return null;
            }
            object2 = new BufferedReader(new InputStreamReader(inputStream));
            int n = 2;
            int n2 = 3;
            int n3 = 4;
            int n4 = 5;
            boolean bl = false;
            arrayList.add(Float.valueOf(f));
            while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                if (string2.length() < 3 || string2.substring(0, 1).equals("#")) continue;
                if (bl) {
                    double d;
                    double d2;
                    double d3;
                    stringArray = string2.trim().split(";");
                    object = stringArray[n];
                    String string3 = stringArray[n2];
                    String object3 = stringArray[n3];
                    String string4 = n4 < stringArray.length ? stringArray[n4] : "";
                    double d4 = Double.parseDouble(((String)object).substring(0, 2));
                    double d5 = Double.parseDouble(((String)object).substring(3, 5));
                    double d6 = Double.parseDouble(((String)object).substring(6));
                    double d7 = d4 * 15.0 + d5 * 0.25 + d6 * 0.0041666 - 180.0;
                    String string5 = string3.substring(0, 1);
                    double d8 = Double.parseDouble(string3.substring(1, 3));
                    double d9 = Double.parseDouble(string3.substring(4, 6));
                    double d10 = Double.parseDouble(string3.substring(7));
                    double d11 = d8 + d9 / 60.0 + d10 / 3600.0;
                    if (string5.equals("-")) {
                        d11 *= -1.0;
                    }
                    if ((d3 = 255.0 - ((d2 = Double.parseDouble(object3)) + 1.5) * 255.0 / 10.0) > 255.0) {
                        d3 = 255.0;
                    }
                    d3 /= 255.0;
                    try {
                        d = Double.parseDouble(string4);
                    }
                    catch (Exception exception) {
                        d = 0.0;
                    }
                    Color color = StarsConvertor.BVColor(d);
                    arrayList.add(Float.valueOf((float)color.getRed() / 255.0f * (float)d3));
                    arrayList.add(Float.valueOf((float)color.getGreen() / 255.0f * (float)d3));
                    arrayList.add(Float.valueOf((float)color.getBlue() / 255.0f * (float)d3));
                    Vec4 vec4 = StarsConvertor.SphericalToCartesian(d11, d7, f);
                    arrayList.add(Float.valueOf((float)vec4.getX()));
                    arrayList.add(Float.valueOf((float)vec4.getY()));
                    arrayList.add(Float.valueOf((float)vec4.getZ()));
                }
                if (!string2.substring(0, 3).equals("---")) continue;
                bl = true;
            }
            ((BufferedReader)object2).close();
            stringArray = Buffers.newDirectByteBuffer((int)(arrayList.size() * 4));
            stringArray.order(ByteOrder.LITTLE_ENDIAN);
            object = stringArray.asFloatBuffer();
            for (Float f2 : arrayList) {
                ((FloatBuffer)object).put(f2.floatValue());
            }
            stringArray.rewind();
            return stringArray;
        }
        catch (IOException iOException) {
            String string6 = "IOException while loading stars data from " + string;
            Logging.logger().severe(string6);
        }
        catch (Exception exception) {
            String string7 = "Error while loading stars data from " + string;
            Logging.logger().severe(string7);
        }
        return null;
    }

    private static Vec4 SphericalToCartesian(double d, double d2, float f) {
        double d3 = (double)f * Math.cos(d *= Math.PI / 180);
        return new Vec4(d3 * Math.sin(d2 *= Math.PI / 180), (double)f * Math.sin(d), d3 * Math.cos(d2));
    }

    private static Color BVColor(double d) {
        if (d < 0.0) {
            return new Color(0.635f, 0.764f, 0.929f);
        }
        if (d < 0.5) {
            return new Color(1.0f, 1.0f, 1.0f);
        }
        if (d < 1.0) {
            return new Color(1.0f, 0.984f, 0.266f);
        }
        if (d < 1.5) {
            return new Color(0.964f, 0.725f, 0.0784f);
        }
        return new Color(0.921f, 0.376f, 0.0392f);
    }

    public static void main(String[] stringArray) {
        float f;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(null);
        if (n != 0) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        if (fileArray == null) {
            System.out.println("No files selected");
            return;
        }
        String string = JOptionPane.showInputDialog("Enter star sphere radius?", (Object)Float.valueOf(6.356752E7f));
        while (true) {
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = Logging.getMessage("generic.NumberFormatException");
                Logging.logger().warning(string2);
                string = JOptionPane.showInputDialog("<html><font color=#ff0000>INVALID VALUE: Please enter a floating point number.</font><br>Enter star sphere radius?</html>", (Object)Float.valueOf(6.356752E7f));
                continue;
            }
            break;
        }
        for (File file : fileArray) {
            StarsConvertor.convertTsvToDat(file.getAbsolutePath(), f);
        }
    }
}

