/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.placename;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.event.BulkRetrievalEvent;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameService;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.RetrievalService;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.Logging;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class PlaceNameLayerBulkDownloader
extends BulkRetrievalThread {
    protected static final long AVG_TILE_SIZE = 8192L;
    protected int MAX_TILE_COUNT_PER_REGION = 200;
    protected final PlaceNameLayer layer;
    protected ArrayList<PlaceNameLayer.Tile> missingTiles;
    protected long pollDelay = this.RETRIEVAL_SERVICE_POLL_DELAY;

    public PlaceNameLayerBulkDownloader(PlaceNameLayer placeNameLayer, Sector sector, double d, BulkRetrievalListener bulkRetrievalListener) {
        super(placeNameLayer, sector, d, placeNameLayer.getDataFileStore(), bulkRetrievalListener);
        this.layer = placeNameLayer;
    }

    public PlaceNameLayerBulkDownloader(PlaceNameLayer placeNameLayer, Sector sector, double d, FileStore fileStore, BulkRetrievalListener bulkRetrievalListener) {
        super(placeNameLayer, sector, d, fileStore, bulkRetrievalListener);
        this.layer = placeNameLayer;
    }

    @Override
    public void run() {
        try {
            this.missingTiles = new ArrayList();
            ArrayList<PlaceNameLayer.Tile> arrayList = this.getMissingTilesInSector(this.sector);
            this.progress.setTotalCount(arrayList.size());
            while (arrayList.size() > 0) {
                this.transferMissingTiles(arrayList, this.missingTiles, this.MAX_TILE_COUNT_PER_REGION);
                while (this.missingTiles.size() > 0) {
                    this.submitMissingTilesRequests();
                    if (this.missingTiles.size() <= 0) continue;
                    Thread.sleep(this.pollDelay);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            String string = Logging.getMessage("generic.BulkRetrievalInterrupted", this.layer.getName());
            Logging.logger().log(Level.WARNING, string, interruptedException);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionDuringBulkRetrieval", this.layer.getName());
            Logging.logger().severe(string);
            throw new RuntimeException(string);
        }
    }

    protected void transferMissingTiles(ArrayList<PlaceNameLayer.Tile> arrayList, ArrayList<PlaceNameLayer.Tile> arrayList2, int n) {
        for (int i = 0; i < n && arrayList.size() > 0; ++i) {
            arrayList2.add(arrayList.remove(0));
        }
    }

    protected synchronized void submitMissingTilesRequests() throws InterruptedException {
        RetrievalService retrievalService = WorldWind.getRetrievalService();
        int n = 0;
        while (this.missingTiles.size() > n && retrievalService.isAvailable()) {
            Thread.sleep(1L);
            PlaceNameLayer.Tile tile = this.missingTiles.get(n);
            if (this.isTileLocalOrAbsent(tile)) {
                this.missingTiles.remove(n);
                continue;
            }
            this.layer.downloadTile(tile, new BulkDownloadPostProcessor(this.layer, tile, this.fileStore));
            ++n;
        }
    }

    protected void callRetrievalListeners(Retriever retriever, PlaceNameLayer.Tile tile) {
        String string = retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful") ? BulkRetrievalEvent.RETRIEVAL_SUCCEEDED : BulkRetrievalEvent.RETRIEVAL_FAILED;
        super.callRetrievalListeners(new BulkRetrievalEvent(this.layer, string, tile.getFileCachePath()));
    }

    protected synchronized void removeRetrievedTile(PlaceNameLayer.Tile tile) {
        this.missingTiles.remove(tile);
        this.progress.setCurrentCount(this.progress.getCurrentCount() + 1L);
        this.progress.setCurrentSize(this.progress.getCurrentSize() + 8192L);
        this.progress.setLastUpdateTime(System.currentTimeMillis());
        this.progress.setTotalSize(this.progress.getCurrentSize() / this.progress.getCurrentCount() * this.progress.getTotalCount());
    }

    protected long getEstimatedMissingDataSize() {
        int n;
        try {
            n = this.getMissingTilesCountEstimate(this.sector, this.resolution);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionDuringDataSizeEstimate", this.getName());
            Logging.logger().severe(string);
            throw new RuntimeException(string);
        }
        return (long)n * 8192L;
    }

    protected int getMissingTilesCountEstimate(Sector sector, double d) {
        int n = 0;
        int n2 = this.layer.getPlaceNameServiceSet().getServiceCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            PlaceNameService placeNameService = this.layer.getPlaceNameServiceSet().getService(i);
            if (placeNameService.getMaxDisplayDistance() > d) {
                PlaceNameLayer.NavigationTile navigationTile = this.layer.navTiles.get(i);
                List<PlaceNameLayer.NavigationTile> list = this.navTilesVisible(navigationTile, sector);
                for (PlaceNameLayer.NavigationTile navigationTile2 : list) {
                    n3 += this.estimateNumberTilesinSector(navigationTile2, sector);
                }
            }
            n += n3;
        }
        return n;
    }

    protected ArrayList<PlaceNameLayer.Tile> getMissingTilesInSector(Sector sector) throws InterruptedException {
        ArrayList<PlaceNameLayer.Tile> arrayList = new ArrayList<PlaceNameLayer.Tile>();
        int n = this.layer.getPlaceNameServiceSet().getServiceCount();
        for (int i = 0; i < n; ++i) {
            PlaceNameService placeNameService = this.layer.getPlaceNameServiceSet().getService(i);
            if (!(placeNameService.getMaxDisplayDistance() > this.resolution)) continue;
            ArrayList<PlaceNameLayer.Tile> arrayList2 = new ArrayList<PlaceNameLayer.Tile>();
            PlaceNameLayer.NavigationTile navigationTile = this.layer.navTiles.get(i);
            List<PlaceNameLayer.NavigationTile> list = this.navTilesVisible(navigationTile, sector);
            for (PlaceNameLayer.NavigationTile navigationTile2 : list) {
                arrayList2.addAll(navigationTile2.getTiles());
            }
            for (PlaceNameLayer.Tile tile : arrayList2) {
                if (!tile.getSector().intersects(sector) || this.isTileLocalOrAbsent(tile)) continue;
                arrayList.add(tile);
            }
        }
        return arrayList;
    }

    protected List<PlaceNameLayer.NavigationTile> navTilesVisible(PlaceNameLayer.NavigationTile navigationTile, Sector sector) {
        ArrayList<PlaceNameLayer.NavigationTile> arrayList = new ArrayList<PlaceNameLayer.NavigationTile>();
        if (navigationTile.navSector.intersects(sector)) {
            if (navigationTile.level > 0 && !navigationTile.hasSubTiles()) {
                navigationTile.buildSubNavTiles();
            }
            if (navigationTile.hasSubTiles()) {
                for (PlaceNameLayer.NavigationTile navigationTile2 : navigationTile.subNavTiles) {
                    arrayList.addAll(this.navTilesVisible(navigationTile2, sector));
                }
            } else {
                arrayList.add(navigationTile);
            }
        }
        return arrayList;
    }

    protected int estimateNumberTilesinSector(PlaceNameLayer.NavigationTile navigationTile, Sector sector) {
        Angle angle = navigationTile.placeNameService.getTileDelta().getLatitude();
        Angle angle2 = navigationTile.placeNameService.getTileDelta().getLongitude();
        int n = PlaceNameLayer.Tile.computeRow(angle, navigationTile.navSector.getMinLatitude());
        int n2 = PlaceNameLayer.Tile.computeColumn(angle2, navigationTile.navSector.getMinLongitude());
        int n3 = PlaceNameLayer.Tile.computeRow(angle, navigationTile.navSector.getMaxLatitude().subtract(angle));
        int n4 = PlaceNameLayer.Tile.computeColumn(angle2, navigationTile.navSector.getMaxLongitude().subtract(angle2));
        int n5 = 0;
        Angle angle3 = PlaceNameLayer.Tile.computeRowLatitude(n, angle);
        boolean bl = true;
        for (int i = 0; i <= n3 - n; ++i) {
            Angle angle4 = angle3.add(angle);
            Angle angle5 = PlaceNameLayer.Tile.computeColumnLongitude(n2, angle2);
            for (int j = 0; j <= n4 - n2; ++j) {
                Angle angle6 = angle5.add(angle2);
                Sector sector2 = new Sector(angle3, angle4, angle5, angle6);
                if (sector2.intersects(sector)) {
                    if (bl) {
                        String string = navigationTile.placeNameService.createFileCachePathFromTile(i + n, j + n2);
                        URL uRL = this.fileStore.findFile(string, false);
                        if (uRL == null) {
                            bl = false;
                        } else {
                            return 0;
                        }
                    }
                    ++n5;
                }
                angle5 = angle6;
            }
            angle3 = angle4;
        }
        return n5;
    }

    protected boolean isTileLocalOrAbsent(PlaceNameLayer.Tile tile) {
        if (tile.getPlaceNameService().isResourceAbsent(tile.getPlaceNameService().getTileNumber(tile.row, tile.column))) {
            return true;
        }
        URL uRL = this.fileStore.findFile(tile.getFileCachePath(), false);
        return uRL != null;
    }

    protected class BulkDownloadPostProcessor
    extends PlaceNameLayer.DownloadPostProcessor {
        public BulkDownloadPostProcessor(PlaceNameLayer placeNameLayer, PlaceNameLayer.Tile tile, FileStore fileStore) {
            super(placeNameLayer, tile, fileStore);
        }

        @Override
        public ByteBuffer run(Retriever retriever) {
            ByteBuffer byteBuffer = super.run(retriever);
            if (retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                PlaceNameLayerBulkDownloader.this.removeRetrievedTile(this.tile);
            }
            if (PlaceNameLayerBulkDownloader.this.hasRetrievalListeners()) {
                PlaceNameLayerBulkDownloader.this.callRetrievalListeners(retriever, this.tile);
            }
            return byteBuffer;
        }
    }
}

