/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

public class SizeFormatter {
    private static final long ONE_GIGABYTE = 0x40000000L;
    private static final long ONE_MEGABYTE = 0x100000L;
    private static final long ONE_KILOBYTE = 1024L;

    public String formatPrecise(long l) {
        long[] lArray = SizeFormatter.bytesToGbMbKbB(l);
        return String.format("%dGB %dMB %dKB %dbytes", lArray[0], lArray[1], lArray[2], lArray[3]);
    }

    public String formatEstimate(long l) {
        double d = (double)l / 1.073741824E9;
        double d2 = (double)l / 1048576.0;
        double d3 = (double)l / 1024.0;
        String string = d >= 1.0 ? String.format("%.2f GB", d) : (d2 >= 1.0 ? String.format("%.0f MB", d2) : (d3 >= 1.0 ? String.format("%.0f KB", d3) : String.format("%d bytes", l)));
        return string;
    }

    private static long[] bytesToGbMbKbB(long l) {
        return new long[]{(long)(Math.floor((double)l / 1.073741824E9) % 1024.0), (long)(Math.floor((double)l / 1048576.0) % 1024.0), (long)(Math.floor((double)l / 1024.0) % 1024.0), (long)((double)l % 1024.0)};
    }
}

