/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ColladaLibrary<T>
extends ColladaAbstractObject {
    protected String elementName;
    protected List<T> elements = new ArrayList<T>();

    public ColladaLibrary(String string) {
        super(string);
    }

    public List<T> getElements() {
        return this.elements;
    }

    @Override
    public Object parse(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEvent.isStartDocument()) {
            String string = xMLEvent.asStartElement().getName().getLocalPart();
            this.elementName = this.getElementName(string);
        }
        return super.parse(xMLEventParserContext, xMLEvent, objectArray);
    }

    @Override
    public void setField(String string, Object object) {
        if (string.equals(this.elementName)) {
            this.elements.add(object);
        } else {
            super.setField(string, object);
        }
    }

    protected String getElementName(String string) {
        if ("library_nodes".equals(string)) {
            return "node";
        }
        if ("library_effects".equals(string)) {
            return "effect";
        }
        if ("library_materials".equals(string)) {
            return "material";
        }
        if ("library_geometries".equals(string)) {
            return "geometry";
        }
        if ("library_images".equals(string)) {
            return "image";
        }
        if ("library_visual_scenes".equals(string)) {
            return "visual_scene";
        }
        return null;
    }
}

