/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.ogc.collada.ColladaNode;
import gov.nasa.worldwind.ogc.collada.impl.ColladaRenderable;
import gov.nasa.worldwind.ogc.collada.impl.ColladaTraversalContext;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.List;

public class ColladaVisualScene
extends ColladaAbstractObject
implements ColladaRenderable {
    protected List<ColladaNode> nodes = new ArrayList<ColladaNode>();

    public ColladaVisualScene(String string) {
        super(string);
    }

    public List<ColladaNode> getNodes() {
        return this.nodes;
    }

    @Override
    public void setField(String string, Object object) {
        if (string.equals("node")) {
            this.nodes.add((ColladaNode)object);
        } else {
            super.setField(string, object);
        }
    }

    @Override
    public Box getLocalExtent(ColladaTraversalContext colladaTraversalContext) {
        if (colladaTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Box> arrayList = new ArrayList<Box>();
        for (ColladaNode colladaNode : this.getNodes()) {
            Box box = colladaNode.getLocalExtent(colladaTraversalContext);
            if (box == null) continue;
            arrayList.add(box);
        }
        return arrayList.isEmpty() ? null : Box.union(arrayList);
    }

    @Override
    public void preRender(ColladaTraversalContext colladaTraversalContext, DrawContext drawContext) {
        for (ColladaNode colladaNode : this.getNodes()) {
            colladaNode.preRender(colladaTraversalContext, drawContext);
        }
    }

    @Override
    public void render(ColladaTraversalContext colladaTraversalContext, DrawContext drawContext) {
        for (ColladaNode colladaNode : this.getNodes()) {
            colladaNode.render(colladaTraversalContext, drawContext);
        }
    }
}

