/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada.impl;

import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.util.Logging;
import java.util.Stack;

public class ColladaTraversalContext {
    protected Stack<Matrix> matrixStack = new Stack();

    public ColladaTraversalContext() {
        this.matrixStack.push(Matrix.IDENTITY);
    }

    public Matrix peekMatrix() {
        return this.matrixStack.peek();
    }

    public void pushMatrix() {
        this.matrixStack.push(this.peekMatrix());
    }

    public void pushMatrix(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.matrixStack.push(matrix);
    }

    public Matrix popMatrix() {
        return this.matrixStack.pop();
    }

    public void multiplyMatrix(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix2 = this.popMatrix();
        this.pushMatrix(matrix2.multiply(matrix));
    }

    public void initialize() {
        this.matrixStack.clear();
        this.pushMatrix(Matrix.IDENTITY);
    }
}

