/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.ogc.kml.KMLAbstractContainer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLSchema;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLDocument
extends KMLAbstractContainer {
    protected List<KMLSchema> schemas = new ArrayList<KMLSchema>();

    public KMLDocument(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof KMLSchema) {
            this.addSchema((KMLSchema)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addSchema(KMLSchema kMLSchema) {
        this.schemas.add(kMLSchema);
    }

    public List<KMLSchema> getSchemas() {
        return this.schemas;
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLDocument)) {
            String string = Logging.getMessage("KML.InvalidElementType", kMLAbstractObject.getClass().getName());
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        super.applyChange(kMLAbstractObject);
        KMLDocument kMLDocument = (KMLDocument)kMLAbstractObject;
        if (kMLDocument.getSchemas() != null && kMLDocument.getSchemas().size() > 0) {
            this.mergeSchemas(kMLDocument);
        }
    }

    protected void mergeSchemas(KMLDocument kMLDocument) {
        ArrayList arrayList = new ArrayList(this.getSchemas().size());
        Collections.copy(arrayList, this.getSchemas());
        for (KMLSchema kMLSchema : kMLDocument.getSchemas()) {
            String string = kMLSchema.getId();
            if (!WWUtil.isEmpty(string)) {
                for (KMLSchema kMLSchema2 : arrayList) {
                    String string2 = kMLSchema2.getId();
                    if (WWUtil.isEmpty(string2) || !string2.equals(string)) continue;
                    this.getSchemas().remove(kMLSchema2);
                }
            }
            this.getSchemas().add(kMLSchema);
        }
    }
}

