/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wms;

import gov.nasa.worldwind.ogc.OGCCapabilities;
import gov.nasa.worldwind.ogc.OGCOnlineResource;
import gov.nasa.worldwind.ogc.OGCRequestDescription;
import gov.nasa.worldwind.ogc.wms.WMSCapabilityInformation;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSServiceInformation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import gov.nasa.worldwind.wms.CapabilitiesRequest;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WMSCapabilities
extends OGCCapabilities {
    protected static final QName ROOT_ELEMENT_NAME_1_1_1 = new QName("WMT_MS_Capabilities");
    protected static final QName ROOT_ELEMENT_NAME_1_3_0 = new QName("WMS_Capabilities");

    public static WMSCapabilities retrieve(URI uRI) throws Exception {
        try {
            CapabilitiesRequest capabilitiesRequest = new CapabilitiesRequest(uRI);
            return new WMSCapabilities(capabilitiesRequest);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return null;
    }

    public WMSCapabilities(Object object) {
        super("http://www.opengis.net/wms", object);
        this.initialize();
    }

    public WMSCapabilities(CapabilitiesRequest capabilitiesRequest) throws URISyntaxException, MalformedURLException {
        super("http://www.opengis.net/wms", capabilitiesRequest.getUri().toURL());
        this.initialize();
    }

    private void initialize() {
        this.getParserContext().registerParser(new QName(this.getDefaultNamespaceURI(), "Service"), new WMSServiceInformation(this.getNamespaceURI()));
        this.getParserContext().registerParser(new QName("Capability"), new WMSCapabilityInformation(this.getNamespaceURI()));
    }

    @Override
    public String getDefaultNamespaceURI() {
        return "http://www.opengis.net/wms";
    }

    @Override
    public boolean isRootElementName(QName qName) {
        return this.getParserContext().isSameName(qName, ROOT_ELEMENT_NAME_1_1_1) || this.getParserContext().isSameName(qName, ROOT_ELEMENT_NAME_1_3_0);
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.CAPABILITY)) {
            return xMLEventParserContext.allocate(xMLEvent, new WMSCapabilityInformation(this.getNamespaceURI()));
        }
        return super.allocate(xMLEventParserContext, xMLEvent);
    }

    @Override
    public WMSCapabilities parse(Object ... objectArray) throws XMLStreamException {
        return (WMSCapabilities)super.parse(objectArray);
    }

    public List<WMSLayerCapabilities> getNamedLayers() {
        if (this.getCapabilityInformation() == null || this.getCapabilityInformation().getLayerCapabilities() == null) {
            return null;
        }
        ArrayList<WMSLayerCapabilities> arrayList = new ArrayList<WMSLayerCapabilities>();
        for (WMSLayerCapabilities wMSLayerCapabilities : this.getCapabilityInformation().getLayerCapabilities()) {
            arrayList.addAll(wMSLayerCapabilities.getNamedLayers());
        }
        return arrayList;
    }

    public WMSLayerCapabilities getLayerByName(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        List<WMSLayerCapabilities> list = this.getNamedLayers();
        for (WMSLayerCapabilities wMSLayerCapabilities : list) {
            if (!wMSLayerCapabilities.getName().equals(string)) continue;
            return wMSLayerCapabilities;
        }
        return null;
    }

    @Override
    public WMSCapabilityInformation getCapabilityInformation() {
        return (WMSCapabilityInformation)super.getCapabilityInformation();
    }

    public Set<String> getImageFormats() {
        Set<OGCRequestDescription> set = this.getCapabilityInformation().getRequestDescriptions();
        for (OGCRequestDescription oGCRequestDescription : set) {
            if (!oGCRequestDescription.getRequestName().equals("GetMap")) continue;
            return oGCRequestDescription.getFormats();
        }
        return null;
    }

    public Long getLayerLatestLastUpdateTime(WMSCapabilities wMSCapabilities, String[] stringArray) {
        if (wMSCapabilities == null) {
            String string = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (stringArray == null) {
            String string = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = null;
        for (String string2 : stringArray) {
            String string3;
            WMSLayerCapabilities wMSLayerCapabilities = this.getLayerByName(string2);
            if (wMSLayerCapabilities == null || (string3 = this.getLayerLastUpdate(wMSLayerCapabilities)) == null || string3.length() <= 0 || string != null && string3.compareTo(string) <= 0) continue;
            string = string3;
        }
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = Logging.getMessage("generic.ConversionError", string);
                Logging.logger().warning(string4);
            }
        }
        return null;
    }

    protected String getLayerLastUpdate(WMSLayerCapabilities wMSLayerCapabilities) {
        String string = wMSLayerCapabilities.getLastUpdate();
        if (string != null) {
            return string;
        }
        Set<String> set = wMSLayerCapabilities.getKeywords();
        for (String string2 : set) {
            if (!string2.startsWith("LastUpdate=")) continue;
            return this.parseLastUpdate(string2);
        }
        return null;
    }

    protected String parseLastUpdate(String string) {
        String[] stringArray = string.split("=");
        if (stringArray.length != 2) {
            return null;
        }
        String string2 = stringArray[1];
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            string2 = string2.replaceAll("Z", "-0000");
            return Long.toString(simpleDateFormat.parse(string2).getTime());
        }
        catch (ParseException parseException) {
            String string3 = Logging.getMessage("WMS.LastUpdateFormatUnrecognized", string2);
            Logging.logger().info(string3);
            return null;
        }
    }

    public Double[] getLayerExtremeElevations(WMSCapabilities wMSCapabilities, String[] stringArray) {
        if (wMSCapabilities == null) {
            String string = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (stringArray == null) {
            String string = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Double d = null;
        Double d2 = null;
        for (String string : stringArray) {
            Double d3;
            WMSLayerCapabilities wMSLayerCapabilities = wMSCapabilities.getLayerByName(string);
            if (wMSLayerCapabilities == null) continue;
            Double d4 = wMSLayerCapabilities.getExtremeElevationMin();
            if (d4 != null && (d == null || d4.compareTo(d4) > 0)) {
                d = d4;
            }
            if ((d3 = wMSLayerCapabilities.getExtremeElevationMax()) == null || d2 != null && d3.compareTo(d3) <= 0) continue;
            d2 = d3;
        }
        if (d != null || d2 != null) {
            Object[] objectArray = new Double[]{null, null};
            if (d != null) {
                objectArray[0] = d;
            }
            if (d2 != null) {
                objectArray[1] = d2;
            }
            return objectArray;
        }
        return null;
    }

    public OGCRequestDescription getRequestDescription(String string) {
        for (OGCRequestDescription oGCRequestDescription : this.getCapabilityInformation().getRequestDescriptions()) {
            if (!oGCRequestDescription.getRequestName().equalsIgnoreCase(string)) continue;
            return oGCRequestDescription;
        }
        return null;
    }

    public String getRequestURL(String string, String string2, String string3) {
        OGCRequestDescription oGCRequestDescription = this.getRequestDescription(string);
        if (oGCRequestDescription != null) {
            OGCOnlineResource oGCOnlineResource = oGCRequestDescription.getOnlineResouce(string2, string3);
            return oGCOnlineResource != null ? oGCOnlineResource.getHref() : null;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("LAYERS\n");
        for (WMSLayerCapabilities wMSLayerCapabilities : this.getNamedLayers()) {
            stringBuilder.append(wMSLayerCapabilities.toString()).append("\n");
        }
        return stringBuilder.toString();
    }
}

