/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wms;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class WMSLayerDimension
extends AbstractXMLEventParser {
    protected StringBuilder dimension;
    protected String name;
    protected String units;
    protected String unitSymbol;
    protected String defaultValue;
    protected Boolean multipleValues;
    protected Boolean nearestValue;
    protected Boolean current;

    public WMSLayerDimension(String string) {
        super(string);
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        String string;
        if (xMLEvent.isCharacters() && !WWUtil.isEmpty(string = xMLEventParserContext.getCharacters(xMLEvent))) {
            if (this.dimension == null) {
                this.dimension = new StringBuilder();
            }
            this.dimension.append(string);
        }
    }

    @Override
    protected void doParseEventAttributes(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) {
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Boolean bl;
            Attribute attribute = iterator.next();
            if (attribute.getName().getLocalPart().equals("name") && attribute.getValue() != null) {
                this.setName(attribute.getValue());
                continue;
            }
            if (attribute.getName().getLocalPart().equals("units") && attribute.getValue() != null) {
                this.setUnits(attribute.getValue());
                continue;
            }
            if (attribute.getName().getLocalPart().equals("unitSymbol") && attribute.getValue() != null) {
                this.setUnitSymbol(attribute.getValue());
                continue;
            }
            if (attribute.getName().getLocalPart().equals("default") && attribute.getValue() != null) {
                this.setDefaultValue(attribute.getValue());
                continue;
            }
            if (attribute.getName().getLocalPart().equals("multipleValues") && attribute.getValue() != null) {
                bl = WWUtil.convertStringToBoolean(attribute.getValue());
                if (bl == null) continue;
                this.setMultipleValues(bl);
                continue;
            }
            if (attribute.getName().getLocalPart().equals("nearestValue") && attribute.getValue() != null) {
                bl = WWUtil.convertStringToBoolean(attribute.getValue());
                if (bl == null) continue;
                this.setNearestValue(bl);
                continue;
            }
            if (!attribute.getName().getLocalPart().equals("current") || attribute.getValue() == null || (bl = WWUtil.convertStringToBoolean(attribute.getValue())) == null) continue;
            this.setCurrent(bl);
        }
    }

    public String getDimension() {
        if (this.dimension == null) {
            this.dimension = new StringBuilder();
        }
        return this.dimension.toString();
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getUnits() {
        return this.units;
    }

    protected void setUnits(String string) {
        this.units = string;
    }

    public String getUnitSymbol() {
        return this.unitSymbol;
    }

    protected void setUnitSymbol(String string) {
        this.unitSymbol = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public Boolean isMultipleValues() {
        return this.multipleValues;
    }

    protected void setMultipleValues(Boolean bl) {
        this.multipleValues = bl;
    }

    public Boolean isNearestValue() {
        return this.nearestValue;
    }

    protected void setNearestValue(Boolean bl) {
        this.nearestValue = bl;
    }

    public Boolean isCurrent() {
        return this.current;
    }

    protected void setCurrent(Boolean bl) {
        this.current = bl;
    }
}

