/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wms;

import gov.nasa.worldwind.ogc.wms.WMSLayerInfoURL;
import gov.nasa.worldwind.ogc.wms.WMSLogoURL;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WMSLayerStyle
extends AbstractXMLEventParser {
    protected QName NAME;
    protected QName TITLE;
    protected QName ABSTRACT;
    protected QName LEGEND_URL;
    protected QName STYLE_SHEET_URL;
    protected QName STYLE_URL;
    protected String name;
    protected String title;
    protected String styleAbstract;
    protected WMSLayerInfoURL styleSheetURL;
    protected WMSLayerInfoURL styleURL;
    protected Set<WMSLogoURL> legendURLs;

    public WMSLayerStyle(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.NAME = new QName(this.getNamespaceURI(), "Name");
        this.TITLE = new QName(this.getNamespaceURI(), "Title");
        this.ABSTRACT = new QName(this.getNamespaceURI(), "Abstract");
        this.LEGEND_URL = new QName(this.getNamespaceURI(), "LegendURL");
        this.STYLE_SHEET_URL = new QName(this.getNamespaceURI(), "StyleSheetURL");
        this.STYLE_URL = new QName(this.getNamespaceURI(), "StyleURL");
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        WMSLayerInfoURL wMSLayerInfoURL = null;
        XMLEventParser xMLEventParser = super.allocate(xMLEventParserContext, xMLEvent);
        if (xMLEventParser != null) {
            return xMLEventParser;
        }
        if (xMLEventParserContext.isStartElement(xMLEvent, this.LEGEND_URL)) {
            wMSLayerInfoURL = new WMSLogoURL(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.STYLE_SHEET_URL)) {
            wMSLayerInfoURL = new WMSLayerInfoURL(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.STYLE_URL)) {
            wMSLayerInfoURL = new WMSLayerInfoURL(this.getNamespaceURI());
        }
        return xMLEventParserContext.allocate(xMLEvent, wMSLayerInfoURL);
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object;
        XMLEventParser xMLEventParser;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.TITLE)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.setTitle(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.NAME)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.setName(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ABSTRACT)) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.setStyleAbstract(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.LEGEND_URL)) {
            Object object2;
            XMLEventParser xMLEventParser2 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser2 != null && (object2 = xMLEventParser2.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object2 instanceof WMSLogoURL) {
                this.addLegendURL((WMSLogoURL)object2);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.STYLE_SHEET_URL)) {
            Object object3;
            XMLEventParser xMLEventParser3 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser3 != null && (object3 = xMLEventParser3.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object3 instanceof WMSLayerInfoURL) {
                this.setStyleSheetURL((WMSLayerInfoURL)object3);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.STYLE_URL) && (xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent)) != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof WMSLayerInfoURL) {
            this.setStyleURL((WMSLayerInfoURL)object);
        }
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String string) {
        this.title = string;
    }

    public String getStyleAbstract() {
        return this.styleAbstract;
    }

    protected void setStyleAbstract(String string) {
        this.styleAbstract = string;
    }

    public WMSLayerInfoURL getStyleSheetURL() {
        return this.styleSheetURL;
    }

    protected void setStyleSheetURL(WMSLayerInfoURL wMSLayerInfoURL) {
        this.styleSheetURL = wMSLayerInfoURL;
    }

    public WMSLayerInfoURL getStyleURL() {
        return this.styleURL;
    }

    protected void setStyleURL(WMSLayerInfoURL wMSLayerInfoURL) {
        this.styleURL = wMSLayerInfoURL;
    }

    public Set<WMSLogoURL> getLegendURLs() {
        if (this.legendURLs != null) {
            return this.legendURLs;
        }
        return Collections.emptySet();
    }

    protected void setLegendURLs(Set<WMSLogoURL> set) {
        this.legendURLs = set;
    }

    protected void addLegendURL(WMSLogoURL wMSLogoURL) {
        if (this.legendURLs == null) {
            this.legendURLs = new HashSet<WMSLogoURL>();
        }
        this.getLegendURLs().add(wMSLogoURL);
    }
}

