/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.poi;

import gov.nasa.worldwind.exception.NoItemException;
import gov.nasa.worldwind.exception.ServiceException;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.poi.BasicPointOfInterest;
import gov.nasa.worldwind.poi.Gazetteer;
import gov.nasa.worldwind.poi.POIUtils;
import gov.nasa.worldwind.poi.PointOfInterest;
import gov.nasa.worldwind.util.Logging;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class YahooGazetteer
implements Gazetteer {
    protected static final String GEOCODE_SERVICE = "http://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20geo.placefinder%20where%20text%3D";

    @Override
    public List<PointOfInterest> findPlaces(String string) throws NoItemException, ServiceException {
        String string2;
        String string3;
        if (string == null || string.length() < 1) {
            return null;
        }
        try {
            string3 = "http://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20geo.placefinder%20where%20text%3D%22" + URLEncoder.encode(string, "UTF-8") + "%22";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = "http://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20geo.placefinder%20where%20text%3D%22" + string.replaceAll(" ", "+") + "%22";
        }
        if (this.isNumber(string)) {
            string = string + "%20and%20gflags%3D%22R%22";
        }
        if ((string2 = POIUtils.callService(string3)) == null || string2.length() < 1) {
            return null;
        }
        return this.parseLocationString(string2);
    }

    protected boolean isNumber(String string) {
        return (string = string.trim()).startsWith("-") || string.startsWith("+") || Character.isDigit(string.charAt(0));
    }

    protected ArrayList<PointOfInterest> parseLocationString(String string) throws WWRuntimeException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/query/results/Result", document, XPathConstants.NODESET);
            ArrayList<PointOfInterest> arrayList = new ArrayList<PointOfInterest>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string2 = xPath.evaluate("latitude", node);
                String string3 = xPath.evaluate("longitude", node);
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = xPath.evaluate("house", node);
                String string5 = xPath.evaluate("street", node);
                if (string4 != null && !string4.equals("")) {
                    stringBuilder.append(string4);
                    stringBuilder.append(" ");
                }
                if (string5 != null && !string5.equals("")) {
                    stringBuilder.append(string5);
                    stringBuilder.append(", ");
                }
                stringBuilder.append(xPath.evaluate("city", node));
                stringBuilder.append(", ");
                stringBuilder.append(xPath.evaluate("state", node));
                if (string2 == null || string3 == null) continue;
                LatLon latLon = LatLon.fromDegrees(Double.parseDouble(string2), Double.parseDouble(string3));
                BasicPointOfInterest basicPointOfInterest = new BasicPointOfInterest(latLon);
                basicPointOfInterest.setValue("gov.nasa.worldwind.avkey.DisplayName", stringBuilder.toString());
                arrayList.add(basicPointOfInterest);
            }
            return arrayList;
        }
        catch (Exception exception) {
            String string6 = Logging.getMessage("Gazetteer.URLException", string);
            Logging.logger().log(Level.SEVERE, string6);
            throw new WWRuntimeException(string6);
        }
    }
}

