/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.Restorable;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.cache.ShapeDataCache;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.ExtentHolder;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicExtent;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwind.render.LazilyLoadedTexture;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.OutlinedShape;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import javax.media.opengl.GL2;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractShape
extends WWObjectImpl
implements Highlightable,
OrderedRenderable,
Movable,
ExtentHolder,
GeographicExtent,
Exportable,
Restorable {
    protected static final Material DEFAULT_INTERIOR_MATERIAL = Material.LIGHT_GRAY;
    protected static final Material DEFAULT_OUTLINE_MATERIAL = Material.DARK_GRAY;
    protected static final Material DEFAULT_HIGHLIGHT_MATERIAL = Material.WHITE;
    protected static final int DEFAULT_ALTITUDE_MODE = 0;
    protected static final int DEFAULT_OUTLINE_PICK_WIDTH = 10;
    protected static final int DEFAULT_GEOMETRY_GENERATION_INTERVAL = 3000;
    protected static final int VBO_THRESHOLD = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.VBOThreshold", 30);
    protected static ShapeAttributes defaultAttributes = new BasicShapeAttributes();
    protected ShapeAttributes normalAttrs;
    protected ShapeAttributes highlightAttrs;
    protected ShapeAttributes activeAttributes = new BasicShapeAttributes();
    protected boolean highlighted;
    protected boolean visible = true;
    protected int altitudeMode = 0;
    protected boolean enableBatchRendering = true;
    protected boolean enableBatchPicking = true;
    protected boolean enableDepthOffset;
    protected int outlinePickWidth = 10;
    protected Sector sector;
    protected Position referencePosition;
    protected Object delegateOwner;
    protected long maxExpiryTime = 3000L;
    protected long minExpiryTime = Math.max(2500, 0);
    protected boolean viewDistanceExpiration = true;
    protected OGLStackHandler BEogsh = new OGLStackHandler();
    protected Layer pickLayer;
    protected PickSupport pickSupport = new PickSupport();
    protected ShapeDataCache shapeDataCache = new ShapeDataCache(60000L);
    protected AbstractShapeData currentData;
    protected OutlinedShape outlineShapeRenderer = new OutlinedShape(){

        @Override
        public boolean isDrawOutline(DrawContext drawContext, Object object) {
            return ((AbstractShape)object).mustDrawOutline();
        }

        @Override
        public boolean isDrawInterior(DrawContext drawContext, Object object) {
            return ((AbstractShape)object).mustDrawInterior();
        }

        @Override
        public boolean isEnableDepthOffset(DrawContext drawContext, Object object) {
            return ((AbstractShape)object).isEnableDepthOffset();
        }

        @Override
        public void drawOutline(DrawContext drawContext, Object object) {
            ((AbstractShape)object).drawOutline(drawContext);
        }

        @Override
        public void drawInterior(DrawContext drawContext, Object object) {
            ((AbstractShape)object).drawInterior(drawContext);
        }

        @Override
        public Double getDepthOffsetFactor(DrawContext drawContext, Object object) {
            return null;
        }

        @Override
        public Double getDepthOffsetUnits(DrawContext drawContext, Object object) {
            return null;
        }
    };

    public abstract List<Intersection> intersect(Line var1, Terrain var2) throws InterruptedException;

    protected abstract void initialize();

    protected abstract boolean mustApplyTexture(DrawContext var1);

    protected abstract boolean doMakeOrderedRenderable(DrawContext var1);

    protected abstract boolean isOrderedRenderableValid(DrawContext var1);

    protected abstract void doDrawOutline(DrawContext var1);

    protected abstract void doDrawInterior(DrawContext var1);

    protected abstract void fillVBO(DrawContext var1);

    protected abstract void doExportAsKML(XMLStreamWriter var1) throws IOException, XMLStreamException;

    protected abstract AbstractShapeData createCacheEntry(DrawContext var1);

    protected AbstractShapeData getCurrentData() {
        return this.currentData;
    }

    protected AbstractShape() {
        this.initialize();
    }

    protected void reset() {
        this.shapeDataCache.removeAllEntries();
        this.sector = null;
    }

    public ShapeAttributes getAttributes() {
        return this.normalAttrs;
    }

    public void setAttributes(ShapeAttributes shapeAttributes) {
        this.normalAttrs = shapeAttributes;
    }

    public ShapeAttributes getHighlightAttributes() {
        return this.highlightAttrs;
    }

    public void setHighlightAttributes(ShapeAttributes shapeAttributes) {
        this.highlightAttrs = shapeAttributes;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int n) {
        if (this.altitudeMode == n) {
            return;
        }
        this.altitudeMode = n;
        this.reset();
    }

    @Override
    public double getDistanceFromEye() {
        return this.getCurrentData() != null ? this.getCurrentData().getEyeDistance() : 0.0;
    }

    public boolean isEnableBatchRendering() {
        return this.enableBatchRendering;
    }

    public void setEnableBatchRendering(boolean bl) {
        this.enableBatchRendering = bl;
    }

    public boolean isEnableBatchPicking() {
        return this.enableBatchPicking;
    }

    public void setEnableBatchPicking(boolean bl) {
        this.enableBatchPicking = bl;
    }

    public int getOutlinePickWidth() {
        return this.outlinePickWidth;
    }

    public void setOutlinePickWidth(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlinePickWidth = n;
    }

    public boolean isEnableDepthOffset() {
        return this.enableDepthOffset;
    }

    public void setEnableDepthOffset(boolean bl) {
        this.enableDepthOffset = bl;
    }

    public long getGeometryRegenerationInterval() {
        return this.maxExpiryTime;
    }

    public void setGeometryRegenerationInterval(int n) {
        this.maxExpiryTime = Math.max(n, 0);
        this.minExpiryTime = (long)(0.6 * (double)this.maxExpiryTime);
        for (ShapeDataCache.ShapeDataCacheEntry shapeDataCacheEntry : this.shapeDataCache) {
            if (shapeDataCacheEntry == null) continue;
            shapeDataCacheEntry.getTimer().setExpiryTime(this.minExpiryTime, this.maxExpiryTime);
        }
    }

    public void setReferencePosition(Position position) {
        this.referencePosition = position;
        this.reset();
    }

    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    public Extent getExtent() {
        return this.getCurrentData().getExtent();
    }

    public Vec4 getReferencePoint() {
        return this.currentData.getReferencePoint();
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        if (globe == null) {
            return null;
        }
        ShapeDataCache.ShapeDataCacheEntry shapeDataCacheEntry = this.shapeDataCache.getEntry(globe);
        return shapeDataCacheEntry != null && !shapeDataCacheEntry.isExpired(null) && shapeDataCacheEntry.getExtent() != null ? shapeDataCacheEntry.getExtent() : null;
    }

    protected void determineActiveAttributes() {
        if (this.isHighlighted()) {
            if (this.getHighlightAttributes() != null) {
                this.activeAttributes.copy(this.getHighlightAttributes());
            } else {
                if (this.getAttributes() != null) {
                    this.activeAttributes.copy(this.getAttributes());
                } else {
                    this.activeAttributes.copy(defaultAttributes);
                }
                this.activeAttributes.setOutlineMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
                this.activeAttributes.setInteriorMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
            }
        } else if (this.getAttributes() != null) {
            this.activeAttributes.copy(this.getAttributes());
        } else {
            this.activeAttributes.copy(defaultAttributes);
        }
    }

    public ShapeAttributes getActiveAttributes() {
        return this.activeAttributes;
    }

    protected boolean mustRegenerateGeometry(DrawContext drawContext) {
        return this.getCurrentData().isExpired(drawContext) || !this.getCurrentData().isValid(drawContext);
    }

    protected boolean shouldUseVBOs(DrawContext drawContext) {
        return drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject();
    }

    protected boolean mustDrawInterior() {
        return this.getActiveAttributes().isDrawInterior();
    }

    protected boolean mustDrawOutline() {
        return this.getActiveAttributes().isDrawOutline();
    }

    protected boolean mustApplyLighting(DrawContext drawContext) {
        return this.mustApplyLighting(drawContext, null);
    }

    protected boolean mustApplyLighting(DrawContext drawContext, ShapeAttributes shapeAttributes) {
        return shapeAttributes != null ? shapeAttributes.isEnableLighting() : this.activeAttributes.isEnableLighting();
    }

    protected boolean mustCreateNormals(DrawContext drawContext) {
        return this.mustCreateNormals(drawContext, null);
    }

    protected boolean mustCreateNormals(DrawContext drawContext, ShapeAttributes shapeAttributes) {
        return this.mustApplyLighting(drawContext, shapeAttributes);
    }

    protected WWTexture makeTexture(Object object) {
        return new LazilyLoadedTexture(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.render(drawContext);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.currentData = (AbstractShapeData)this.shapeDataCache.getEntry(drawContext.getGlobe());
        if (this.currentData == null) {
            this.currentData = this.createCacheEntry(drawContext);
            this.shapeDataCache.addEntry(this.currentData);
        }
        if (drawContext.getSurfaceGeometry() == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.isTerrainDependent()) {
            this.checkViewDistanceExpiration(drawContext);
        }
        if (this.getExtent() != null) {
            if (!this.intersectsFrustum(drawContext)) {
                return;
            }
            if (drawContext.isSmall(this.getExtent(), 1)) {
                return;
            }
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext);
        } else {
            this.makeOrderedRenderable(drawContext);
        }
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        if (drawContext.getFrameTimeStamp() != this.getCurrentData().getFrameNumber()) {
            this.determineActiveAttributes();
            if (this.getActiveAttributes() == null) {
                return;
            }
            if (this.mustRegenerateGeometry(drawContext)) {
                if (!this.doMakeOrderedRenderable(drawContext)) {
                    return;
                }
                if (this.shouldUseVBOs(drawContext)) {
                    this.fillVBO(drawContext);
                }
                this.getCurrentData().restartTimer(drawContext);
            }
            this.getCurrentData().setFrameNumber(drawContext.getFrameTimeStamp());
        }
        if (!this.isOrderedRenderableValid(drawContext)) {
            return;
        }
        if (drawContext.isPickingMode()) {
            this.pickLayer = drawContext.getCurrentLayer();
        }
        this.addOrderedRenderable(drawContext);
    }

    protected void addOrderedRenderable(DrawContext drawContext) {
        drawContext.addOrderedRenderable(this);
    }

    protected boolean isTerrainDependent() {
        return this.getAltitudeMode() != 0;
    }

    public boolean isViewDistanceExpiration() {
        return this.viewDistanceExpiration;
    }

    public void setViewDistanceExpiration(boolean bl) {
        this.viewDistanceExpiration = bl;
    }

    protected void checkViewDistanceExpiration(DrawContext drawContext) {
        if (!this.isViewDistanceExpiration()) {
            return;
        }
        Vec4 vec4 = this.currentData.getReferencePoint();
        if (vec4 == null) {
            return;
        }
        double d = drawContext.getView().getEyePoint().distanceTo3(vec4);
        Double d2 = this.currentData.getReferenceDistance();
        if (d2 == null || Math.abs(d - d2) / d2 > 0.1) {
            this.currentData.setExpired(true);
            this.currentData.setExtent(null);
            this.currentData.setReferenceDistance(d);
        }
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        if (this.getExtent() == null) {
            return true;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(this.getExtent());
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(this.getExtent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedRenderable(DrawContext drawContext) {
        this.beginDrawing(drawContext, 0);
        try {
            this.doDrawOrderedRenderable(drawContext, this.pickSupport);
            if (this.isEnableBatchRendering()) {
                this.drawBatched(drawContext);
            }
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void drawBatched(DrawContext drawContext) {
        block3: {
            AbstractShape abstractShape;
            OrderedRenderable orderedRenderable;
            block2: {
                AbstractShape abstractShape2;
                orderedRenderable = drawContext.peekOrderedRenderables();
                if (drawContext.isPickingMode()) break block2;
                while (orderedRenderable != null && orderedRenderable.getClass() == this.getClass() && (abstractShape2 = (AbstractShape)orderedRenderable).isEnableBatchRendering()) {
                    drawContext.pollOrderedRenderables();
                    abstractShape2.doDrawOrderedRenderable(drawContext, this.pickSupport);
                    orderedRenderable = drawContext.peekOrderedRenderables();
                }
                break block3;
            }
            if (!this.isEnableBatchPicking()) break block3;
            while (orderedRenderable != null && orderedRenderable.getClass() == this.getClass() && (abstractShape = (AbstractShape)orderedRenderable).isEnableBatchRendering() && abstractShape.isEnableBatchPicking() && abstractShape.pickLayer == this.pickLayer) {
                drawContext.pollOrderedRenderables();
                abstractShape.doDrawOrderedRenderable(drawContext, this.pickSupport);
                orderedRenderable = drawContext.peekOrderedRenderables();
            }
        }
    }

    protected void doDrawOrderedRenderable(DrawContext drawContext, PickSupport pickSupport) {
        GL2 gL2 = drawContext.getGL().getGL2();
        drawContext.getView().setReferenceCenter(drawContext, this.getCurrentData().getReferencePoint());
        if (drawContext.isPickingMode()) {
            Color color = drawContext.getUniquePickColor();
            pickSupport.addPickableObject(this.createPickedObject(color.getRGB()));
            gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        drawContext.drawOutlinedShape(this.outlineShapeRenderer, this);
    }

    protected PickedObject createPickedObject(DrawContext drawContext, Color color) {
        return this.createPickedObject(color.getRGB());
    }

    protected PickedObject createPickedObject(int n) {
        return new PickedObject(n, this.getDelegateOwner() != null ? this.getDelegateOwner() : this);
    }

    protected OGLStackHandler beginDrawing(DrawContext drawContext, int n) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.BEogsh.clear();
        this.BEogsh.pushAttrib(gL2, n |= 0xD10D);
        if (!drawContext.isPickingMode()) {
            drawContext.beginStandardLighting();
            gL2.glEnable(2848);
            gL2.glEnable(3042);
            OGLUtil.applyBlending(gL2, false);
        } else {
            gL2.glDisable(2848);
            gL2.glDisable(3042);
        }
        gL2.glDisable(2884);
        this.BEogsh.pushClientAttrib(gL2, 2);
        gL2.glEnableClientState(32884);
        drawContext.getView().pushReferenceCenter(drawContext, this.getCurrentData().getReferencePoint());
        return this.BEogsh;
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        drawContext.getView().popReferenceCenter(drawContext);
        gL2.glDisableClientState(32885);
        if (!drawContext.isPickingMode()) {
            drawContext.endStandardLighting();
            gL2.glDisable(3553);
            gL2.glBindTexture(3553, 0);
        }
        this.BEogsh.pop(gL2);
    }

    protected void drawOutline(DrawContext drawContext) {
        ShapeAttributes shapeAttributes = this.getActiveAttributes();
        this.prepareToDrawOutline(drawContext, shapeAttributes, defaultAttributes);
        this.doDrawOutline(drawContext);
    }

    protected void prepareToDrawOutline(DrawContext drawContext, ShapeAttributes shapeAttributes, ShapeAttributes shapeAttributes2) {
        if (shapeAttributes == null || !shapeAttributes.isDrawOutline()) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode()) {
            Material material = shapeAttributes.getOutlineMaterial();
            if (material == null) {
                material = shapeAttributes2.getOutlineMaterial();
            }
            if (this.mustApplyLighting(drawContext, shapeAttributes)) {
                material.apply(gL2, 1032, (float)shapeAttributes.getOutlineOpacity());
                gL2.glEnable(2896);
                gL2.glEnableClientState(32885);
            } else {
                Color color = material.getDiffuse();
                double d = shapeAttributes.getOutlineOpacity();
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)(d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
                gL2.glDisable(2896);
                gL2.glDisableClientState(32885);
            }
            gL2.glHint(3154, shapeAttributes.isEnableAntialiasing() ? 4354 : 4352);
        }
        if (drawContext.isPickingMode() && shapeAttributes.getOutlineWidth() < (double)this.getOutlinePickWidth()) {
            gL2.glLineWidth((float)this.getOutlinePickWidth());
        } else {
            gL2.glLineWidth((float)shapeAttributes.getOutlineWidth());
        }
        if (shapeAttributes.getOutlineStippleFactor() > 0) {
            gL2.glEnable(2852);
            gL2.glLineStipple(shapeAttributes.getOutlineStippleFactor(), shapeAttributes.getOutlineStipplePattern());
        } else {
            gL2.glDisable(2852);
        }
        gL2.glDisable(3553);
    }

    protected void drawInterior(DrawContext drawContext) {
        this.prepareToDrawInterior(drawContext, this.getActiveAttributes(), defaultAttributes);
        this.doDrawInterior(drawContext);
    }

    protected void prepareToDrawInterior(DrawContext drawContext, ShapeAttributes shapeAttributes, ShapeAttributes shapeAttributes2) {
        if (!shapeAttributes.isDrawInterior()) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode()) {
            Material material = shapeAttributes.getInteriorMaterial();
            if (material == null) {
                material = shapeAttributes2.getInteriorMaterial();
            }
            if (this.mustApplyLighting(drawContext, shapeAttributes)) {
                material.apply(gL2, 1032, (float)shapeAttributes.getInteriorOpacity());
                gL2.glEnable(2896);
                gL2.glEnableClientState(32885);
            } else {
                Color color = material.getDiffuse();
                double d = shapeAttributes.getInteriorOpacity();
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)(d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
                gL2.glDisable(2896);
                gL2.glDisableClientState(32885);
            }
            if (shapeAttributes.getInteriorOpacity() < 1.0) {
                gL2.glDepthMask(false);
            }
        }
    }

    protected Vec4 computePoint(Terrain terrain, Position position) {
        if (this.getAltitudeMode() == 1) {
            return terrain.getSurfacePoint(position.getLatitude(), position.getLongitude(), 0.0);
        }
        if (this.getAltitudeMode() == 2) {
            return terrain.getSurfacePoint(position);
        }
        double d = position.getElevation() * terrain.getVerticalExaggeration();
        return terrain.getGlobe().computePointFromPosition(position, d);
    }

    protected Extent computeExtentFromPositions(Globe globe, double d, Iterable<? extends LatLon> iterable) {
        double[] dArray;
        if (globe == null || iterable == null) {
            return null;
        }
        Sector sector = this.getSector();
        if (sector == null) {
            return null;
        }
        double[] dArray2 = globe.getMinAndMaxElevations(sector);
        if (this.getAltitudeMode() != 1) {
            dArray = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
            for (LatLon latLon : iterable) {
                double d2;
                double d3 = d2 = latLon instanceof Position ? ((Position)latLon).getElevation() : 0.0;
                if (this.getAltitudeMode() == 2) {
                    d2 += dArray2[1];
                }
                if (dArray[0] > d2) {
                    dArray[0] = d2 * d;
                }
                if (!(dArray[1] < d2)) continue;
                dArray[1] = d2 * d;
            }
        } else {
            dArray = dArray2;
        }
        return Sector.computeBoundingBox(globe, d, sector, dArray[0], dArray[1]);
    }

    protected int[] getVboIds(DrawContext drawContext) {
        return (int[])drawContext.getGpuResourceCache().get(this.getCurrentData().getVboCacheKey());
    }

    protected void clearCachedVbos(DrawContext drawContext) {
        drawContext.getGpuResourceCache().remove(this.getCurrentData().getVboCacheKey());
    }

    protected int countTriangleVertices(List<List<Integer>> list, List<Integer> list2) {
        int n = 0;
        block5: for (int i = 0; i < list.size(); ++i) {
            switch (list2.get(i)) {
                case 4: {
                    n += list.get(i).size();
                    continue block5;
                }
                case 6: {
                    n += (list.get(i).size() - 2) * 3;
                    continue block5;
                }
                case 5: {
                    n += (list.get(i).size() - 2) * 3;
                }
            }
        }
        return n;
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public String isExportFormatSupported(String string) {
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            return "Export.FormatSupported";
        }
        return "Export.FormatNotSupported";
    }

    @Override
    public void export(String string, Object object) throws IOException, UnsupportedOperationException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.OutputBufferIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = this.isExportFormatSupported(string);
        if ("Export.FormatNotSupported".equals(string4)) {
            String string5 = Logging.getMessage("Export.UnsupportedFormat", string);
            Logging.logger().warning(string5);
            throw new UnsupportedOperationException(string5);
        }
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            try {
                this.exportAsKML(object);
            }
            catch (XMLStreamException xMLStreamException) {
                Logging.logger().throwing(this.getClass().getName(), "export", xMLStreamException);
                throw new IOException(xMLStreamException);
            }
        } else {
            String string6 = Logging.getMessage("Export.UnsupportedFormat", string);
            Logging.logger().warning(string6);
            throw new UnsupportedOperationException(string6);
        }
    }

    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        String string;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string2 = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string2);
            throw new IllegalArgumentException(string2);
        }
        xMLStreamWriter.writeStartElement("Placemark");
        String string3 = (String)this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        if (string3 != null) {
            xMLStreamWriter.writeStartElement("name");
            xMLStreamWriter.writeCharacters(string3);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("visibility");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isVisible()));
        xMLStreamWriter.writeEndElement();
        String string4 = (String)this.getValue("gov.nasa.worldwind.avkey.Server.ShortDescription");
        if (string4 != null) {
            xMLStreamWriter.writeStartElement("Snippet");
            xMLStreamWriter.writeCharacters(string4);
            xMLStreamWriter.writeEndElement();
        }
        if ((string = (String)this.getValue("gov.nasa.worldwind.avkey.BalloonText")) != null) {
            xMLStreamWriter.writeStartElement("description");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
        }
        ShapeAttributes shapeAttributes = this.getAttributes();
        ShapeAttributes shapeAttributes2 = this.getHighlightAttributes();
        if (shapeAttributes != null || shapeAttributes2 != null) {
            xMLStreamWriter.writeStartElement("StyleMap");
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "normal", shapeAttributes);
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "highlight", shapeAttributes2);
            xMLStreamWriter.writeEndElement();
        }
        this.doExportAsKML(xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyGetRestorableState(restorableSupport, stateObject);
    }

    private void doMyGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "highlighted", this.isHighlighted());
        restorableSupport.addStateValueAsBoolean(stateObject, "visible", this.isVisible());
        restorableSupport.addStateValueAsInteger(stateObject, "altitudeMode", this.getAltitudeMode());
        this.normalAttrs.getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "attributes"));
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyRestoreState(restorableSupport, stateObject);
    }

    private void doMyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2;
        Integer n;
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "highlighted");
        if (bl != null) {
            this.setHighlighted(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "visible")) != null) {
            this.setVisible(bl);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "altitudeMode")) != null) {
            this.setAltitudeMode(n);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "attributes")) != null) {
            ShapeAttributes shapeAttributes = this.getAttributes() != null ? this.getAttributes() : new BasicShapeAttributes();
            shapeAttributes.restoreState(restorableSupport, stateObject2);
            this.setAttributes(shapeAttributes);
        }
    }

    static {
        defaultAttributes.setInteriorMaterial(DEFAULT_INTERIOR_MATERIAL);
        defaultAttributes.setOutlineMaterial(DEFAULT_OUTLINE_MATERIAL);
    }

    protected static class AbstractShapeData
    extends ShapeDataCache.ShapeDataCacheEntry {
        protected long frameNumber = -1L;
        protected Vec4 referencePoint;
        protected Double referenceDistance;
        protected Object vboCacheKey = new Object();

        protected AbstractShapeData(DrawContext drawContext, long l, long l2) {
            super(drawContext, l, l2);
        }

        public long getFrameNumber() {
            return this.frameNumber;
        }

        public void setFrameNumber(long l) {
            this.frameNumber = l;
        }

        public Vec4 getReferencePoint() {
            return this.referencePoint;
        }

        public void setReferencePoint(Vec4 vec4) {
            this.referencePoint = vec4;
        }

        public Object getVboCacheKey() {
            return this.vboCacheKey;
        }

        public void setVboCacheKey(Object object) {
            this.vboCacheKey = object;
        }

        public Double getReferenceDistance() {
            return this.referenceDistance;
        }

        public void setReferenceDistance(Double d) {
            this.referenceDistance = d;
        }
    }
}

