/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.util.Logging;

public class ScreenSizeDetailLevel
extends AVListImpl
implements DetailLevel {
    private static final double DEFAULT_MIN_SIZE = 40.0;
    private static final double DEFAULT_MAX_SIZE = 700.0;
    private final double screenSize;
    private final String key;

    public ScreenSizeDetailLevel(double d, String string) {
        this.screenSize = d;
        this.key = string;
    }

    public double getScreenSize() {
        return this.screenSize;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScreenSizeDetailLevel screenSizeDetailLevel = (ScreenSizeDetailLevel)object;
        return Double.compare(this.screenSize, screenSizeDetailLevel.screenSize) == 0;
    }

    @Override
    public int compareTo(DetailLevel detailLevel) {
        if (this == detailLevel) {
            return 0;
        }
        if (detailLevel == null || this.getClass() != detailLevel.getClass()) {
            return -1;
        }
        ScreenSizeDetailLevel screenSizeDetailLevel = (ScreenSizeDetailLevel)detailLevel;
        return Double.compare(this.screenSize, screenSizeDetailLevel.screenSize);
    }

    public int hashCode() {
        long l = this.screenSize != 0.0 ? Double.doubleToLongBits(this.screenSize) : 0L;
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        return this.key;
    }

    @Override
    public boolean meetsCriteria(DrawContext drawContext, Airspace airspace) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = "nullValue.DrawingContextViewIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Extent extent = airspace.getExtent(drawContext);
        if (extent == null) {
            return false;
        }
        double d = drawContext.getView().getEyePoint().distanceTo3(extent.getCenter());
        double d2 = drawContext.getView().computePixelSizeAtDistance(d);
        double d3 = extent.getDiameter() / d2;
        return d3 < this.screenSize;
    }

    public static double[] computeDefaultScreenSizeRamp(int n) {
        return ScreenSizeDetailLevel.computeLinearScreenSizeRamp(n, 40.0, 700.0);
    }

    public static double[] computeLinearScreenSizeRamp(int n, double d, double d2) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i / (double)(n - 1);
            dArray[n - i - 1] = d + d3 * (d2 - d);
        }
        return dArray;
    }
}

